/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.builder;

import com.lyncode.builder.Builder;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.ByteArrayInputStream;
import org.mockito.Mockito;

public class JtwigResourceBuilder
implements Builder<JtwigResource> {
    private JtwigResource resource = (JtwigResource)Mockito.mock(JtwigResource.class);

    public JtwigResourceBuilder withContent(String content) {
        try {
            Mockito.when((Object)this.resource.retrieve()).thenReturn((Object)new ByteArrayInputStream(content.getBytes()));
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return this;
    }

    public JtwigResourceBuilder withRelative(String path, JtwigResourceBuilder builder) {
        try {
            Mockito.when((Object)this.resource.resolve(path)).thenReturn((Object)builder.build());
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return this;
    }

    public JtwigResource build() {
        return this.resource;
    }
}

