/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.content;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.content.ForLoop;
import com.lyncode.jtwig.tree.expressions.Variable;
import java.io.OutputStream;
import java.util.Map;

public class ForPairLoop
extends ForLoop {
    private Variable value;

    public ForPairLoop(Variable key, Variable value, Expression map) {
        super(key, map);
        this.value = value;
    }

    @Override
    public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
        try {
            Object resolved = this.expression.calculate(context);
            if (!(resolved instanceof Map)) {
                throw new RenderException("Expecting a map as parameter for the loop but " + this.expression + " was given");
            }
            Map map = (Map)resolved;
            ForLoop.Loop loop = new ForLoop.Loop(map.size());
            context.set("loop", loop);
            int index = 0;
            for (Object key : map.keySet()) {
                loop.update(index++);
                context.set(this.variable.getIdentifier(), key);
                context.set(this.value.getIdentifier(), map.get(key));
                this.content.render(outputStream, context);
            }
            return true;
        }
        catch (CalculateException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public String toString() {
        return "For each element of " + this.expression + " render " + this.content;
    }
}

