/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.resource;

import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileJtwigResource
implements JtwigResource {
    private static final String PREFIX = "file://";
    private File file;

    public FileJtwigResource(String file) {
        if (file.startsWith(PREFIX)) {
            file = file.substring(PREFIX.length());
        }
        this.file = new File(file);
    }

    public FileJtwigResource(File file) {
        this.file = file;
    }

    @Override
    public InputStream retrieve() throws ResourceException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public JtwigResource resolve(String relativePath) {
        return new FileJtwigResource(new File(this.file.getParentFile(), relativePath));
    }
}

