/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.repository.AbstractFunctionRepository;
import com.lyncode.jtwig.functions.repository.DefaultFunctionRepository;

public class JtwigContext {
    private static final String MODEL = "model";
    private AbstractFunctionRepository functionRepository;
    private JtwigModelMap modelMap;

    public static JtwigContext context() {
        return new JtwigContext();
    }

    public JtwigContext(JtwigModelMap modelMap, AbstractFunctionRepository functionRepository) {
        this.functionRepository = functionRepository;
        this.modelMap = modelMap;
    }

    public JtwigContext(JtwigModelMap modelMap) {
        this.functionRepository = new DefaultFunctionRepository(new JtwigFunction[0]);
        this.modelMap = modelMap;
    }

    public JtwigContext() {
        this.functionRepository = new DefaultFunctionRepository(new JtwigFunction[0]);
        this.modelMap = new JtwigModelMap();
    }

    public JtwigContext withFunction(String name, JtwigFunction function) {
        this.functionRepository.add(function, name, new String[0]);
        return this;
    }

    public JtwigContext withModelAttribute(String key, Object value) {
        this.modelMap.add(key, value);
        return this;
    }

    public JtwigFunction function(String name) throws FunctionNotFoundException {
        return this.functionRepository.retrieve(name);
    }

    public Object map(String key) {
        if (MODEL.equals(key)) {
            return this.modelMap;
        }
        return this.modelMap.get(key);
    }

    public void set(String key, Object value) {
        this.modelMap.add(key, value);
    }
}

