/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.helper;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.util.ObjectIterator;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.Composition;
import com.lyncode.jtwig.tree.expressions.OperationBinary;
import com.lyncode.jtwig.tree.expressions.Operator;
import com.lyncode.jtwig.tree.expressions.Selection;
import com.lyncode.jtwig.util.BooleanOperations;
import com.lyncode.jtwig.util.MathOperations;
import com.lyncode.jtwig.util.RelationalOperations;

public class StrictBinaryOperation
implements Expression {
    private Operator operator;
    private Expression left;
    private Expression right;

    public static StrictBinaryOperation create(OperationBinary binary) {
        int index = 0;
        StrictBinaryOperation last = null;
        for (Operator operator : binary.getOperators()) {
            StrictBinaryOperation operation = new StrictBinaryOperation();
            operation.operator = operator;
            operation.left = last != null ? last : binary.getOperands().get(index);
            operation.right = binary.getOperands().get(index + 1);
            last = operation;
            ++index;
        }
        return last;
    }

    private Object numericExecute(JtwigContext resolver) throws CalculateException {
        switch (this.operator) {
            case ADD: {
                return MathOperations.sum(this.left.calculate(resolver), this.right.calculate(resolver));
            }
            case SUB: {
                return MathOperations.sub(this.left.calculate(resolver), this.right.calculate(resolver));
            }
            case DIV: {
                return MathOperations.div(this.left.calculate(resolver), this.right.calculate(resolver));
            }
            case TIMES: {
                return MathOperations.mul(this.left.calculate(resolver), this.right.calculate(resolver));
            }
            case MOD: {
                return MathOperations.mod(this.left.calculate(resolver), this.right.calculate(resolver));
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    private Object relationalExecute(JtwigContext resolver) throws CalculateException {
        Object leftResolved = this.left.calculate(resolver);
        Object rightResolved = this.right.calculate(resolver);
        switch (this.operator) {
            case GT: {
                return RelationalOperations.gt(leftResolved, rightResolved);
            }
            case GTE: {
                return RelationalOperations.gte(leftResolved, rightResolved);
            }
            case LT: {
                return RelationalOperations.lt(leftResolved, rightResolved);
            }
            case LTE: {
                return RelationalOperations.lte(leftResolved, rightResolved);
            }
            case EQUAL: {
                return RelationalOperations.eq(leftResolved, rightResolved);
            }
            case DIFF: {
                return RelationalOperations.neq(leftResolved, rightResolved);
            }
            case STARTS_WITH: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().startsWith(rightResolved.toString());
            }
            case ENDS_WITH: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().endsWith(rightResolved.toString());
            }
            case MATCHES: {
                if (leftResolved == null) {
                    return false;
                }
                return leftResolved.toString().matches(rightResolved.toString());
            }
            case IN: {
                if (rightResolved == null) {
                    return false;
                }
                if (rightResolved instanceof Iterable || rightResolved.getClass().isArray()) {
                    return new ObjectIterator(rightResolved).contains(leftResolved);
                }
                if (rightResolved instanceof String) {
                    return ((String)rightResolved).contains(leftResolved.toString());
                }
                return false;
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    private Object booleanExecute(JtwigContext resolver) throws CalculateException {
        switch (this.operator) {
            case AND: {
                return BooleanOperations.and(this.left.calculate(resolver), this.right.calculate(resolver));
            }
            case OR: {
                return BooleanOperations.or(this.left.calculate(resolver), this.right.calculate(resolver));
            }
        }
        throw new CalculateException("Unknown operator " + this.operator.toString());
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        switch (this.operator) {
            case COMPOSITION: {
                Composition composition = new Composition(this.left);
                composition.add(this.right);
                return composition.calculate(context);
            }
            case SELECTION: {
                Selection selection = new Selection(this.left);
                selection.add(this.right);
                return selection.calculate(context);
            }
            case IS: {
                Composition composition = new Composition(this.left);
                composition.add(this.right);
                return BooleanOperations.isTrue(composition.calculate(context));
            }
            case IS_NOT: {
                Composition composition = new Composition(this.left);
                composition.add(this.right);
                return !BooleanOperations.isTrue(composition.calculate(context));
            }
            case ADD: 
            case SUB: 
            case DIV: 
            case TIMES: 
            case MOD: 
            case INT_DIV: 
            case INT_TIMES: {
                return this.numericExecute(context);
            }
            case AND: 
            case OR: {
                return this.booleanExecute(context);
            }
        }
        return this.relationalExecute(context);
    }
}

