/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.expressions;

import com.lyncode.builder.ListBuilder;
import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.FunctionElement;
import com.lyncode.jtwig.tree.expressions.Variable;
import java.util.ArrayList;
import java.util.List;

public class Composition
implements Expression {
    private Expression expression;
    private List<FunctionElement> filters = new ArrayList<FunctionElement>();

    public Composition(Expression expression) {
        this.expression = expression;
    }

    public boolean add(Object functionElement) {
        if (functionElement instanceof FunctionElement) {
            this.filters.add((FunctionElement)functionElement);
        } else if (functionElement instanceof Variable) {
            this.filters.add(new FunctionElement(((Variable)functionElement).getIdentifier()));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        try {
            Object resolved = this.expression.calculate(context);
            for (FunctionElement functionElement : this.filters) {
                List arguments = new ListBuilder().add(new Object[]{resolved}).add(functionElement.getArguments().calculate(context).toArray()).build();
                resolved = context.function(functionElement.getName()).execute(arguments.toArray());
            }
            return resolved;
        }
        catch (FunctionException e) {
            throw new CalculateException(e);
        }
        catch (FunctionNotFoundException e) {
            throw new CalculateException(e);
        }
    }
}

