/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser;

import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.parser.JtwigBasicParser;
import com.lyncode.jtwig.parser.JtwigExpressionParser;
import com.lyncode.jtwig.parser.JtwigKeyword;
import com.lyncode.jtwig.parser.JtwigSymbol;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Content;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.content.ForLoop;
import com.lyncode.jtwig.tree.content.ForPairLoop;
import com.lyncode.jtwig.tree.content.IfExpression;
import com.lyncode.jtwig.tree.content.JtwigContent;
import com.lyncode.jtwig.tree.content.Output;
import com.lyncode.jtwig.tree.content.SetVariable;
import com.lyncode.jtwig.tree.content.Text;
import com.lyncode.jtwig.tree.documents.JtwigDocument;
import com.lyncode.jtwig.tree.documents.JtwigExtendsDocument;
import com.lyncode.jtwig.tree.documents.JtwigRootDocument;
import com.lyncode.jtwig.tree.expressions.Variable;
import com.lyncode.jtwig.tree.structural.Block;
import com.lyncode.jtwig.tree.structural.Extends;
import com.lyncode.jtwig.tree.structural.Include;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.common.FileUtils;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class JtwigParser
extends BaseParser<Content> {
    JtwigBasicParser basicParser = (JtwigBasicParser)Parboiled.createParser(JtwigBasicParser.class, (Object[])new Object[0]);
    JtwigExpressionParser expressionParser = (JtwigExpressionParser)Parboiled.createParser(JtwigExpressionParser.class, (Object[])new Object[0]);

    public static JtwigDocument parse(JtwigResource input) throws ParseException {
        try {
            ReportingParseRunner runner = new ReportingParseRunner(((JtwigParser)Parboiled.createParser(JtwigParser.class, (Object[])new Object[0])).start());
            ParsingResult result = runner.run(FileUtils.readAllText((InputStream)input.retrieve(), (Charset)Charset.defaultCharset()));
            return (JtwigDocument)result.resultValue;
        }
        catch (ParserRuntimeException e) {
            if (e.getCause() instanceof ParseBypassException) {
                ParseException innerException = ((ParseBypassException)e.getCause()).getInnerException();
                innerException.setExpression(e.getMessage());
                throw innerException;
            }
            throw new ParseException(e);
        }
        catch (ResourceException e) {
            throw new ParseException(e);
        }
    }

    public Rule start() {
        return this.FirstOf(this.extendTemplate(), this.normalTemplate(), new Object[0]);
    }

    Rule extendTemplate() {
        return this.Sequence(this.basicParser.spacing(), this.Sequence(this.openCode(), this.keyword(JtwigKeyword.EXTENDS), new Object[]{this.mandatory(this.Sequence(this.basicParser.stringLiteral(), this.basicParser.spacing(), new Object[]{this.closeCode(), this.push(new JtwigExtendsDocument(new Extends((String)this.basicParser.pop()))), this.ZeroOrMore(this.basicParser.spacing(), this.block(), new Object[]{((JtwigExtendsDocument)this.peek(1)).add((Block)this.pop())}), this.basicParser.spacing(), EOI}), new ParseException("Wrong include syntax"))}), new Object[0]);
    }

    Rule normalTemplate() {
        return this.Sequence(this.content(), this.push(new JtwigRootDocument((Content)this.pop())), new Object[]{EOI});
    }

    Rule content() {
        return this.Sequence(this.push(new JtwigContent()), this.ZeroOrMore(this.FirstOf(this.addToContent(this.output()), this.addToContent(this.block()), new Object[]{this.addToContent(this.include()), this.addToContent(this.forEach()), this.addToContent(this.ifCondition()), this.addToContent(this.set()), this.addToContent(this.verbatim()), this.Sequence(this.openCode(), this.TestNot(this.FirstOf(this.keyword(JtwigKeyword.ENDBLOCK), this.keyword(JtwigKeyword.ENDFOR), new Object[]{this.keyword(JtwigKeyword.ENDIF), this.keyword(JtwigKeyword.IF), this.keyword(JtwigKeyword.BLOCK), this.keyword(JtwigKeyword.FOR), this.keyword(JtwigKeyword.SET), this.keyword(JtwigKeyword.ELSE), this.keyword(JtwigKeyword.ELSEIF), this.keyword(JtwigKeyword.VERBATIM)})), new Object[]{this.throwException(new ParseException("Unknown tag"))}), this.addToContent(this.text())})), new Object[0]);
    }

    Rule addToContent(Rule innerRule) {
        return this.Sequence(innerRule, ((JtwigContent)this.peek(1)).add(this.pop()), new Object[0]);
    }

    Rule block() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.BLOCK), new Object[]{this.mandatory(this.Sequence(this.expressionParser.variable(), this.push(new Block(((Variable)this.expressionParser.pop()).getIdentifier())), new Object[]{this.closeCode(), this.content(), ((Block)this.peek(1)).setContent((Content)this.pop()), this.openCode(), this.keyword(JtwigKeyword.ENDBLOCK), this.Optional(this.expressionParser.variable(), this.assertEqual(((Block)this.peek()).getName(), ((Variable)this.expressionParser.pop()).getIdentifier()), new Object[0]), this.closeCode()}), new ParseException("Wrong block syntax"))});
    }

    boolean assertEqual(String value1, String value2) {
        if (!value1.equals(value2)) {
            return this.throwException(new ParseException("Start statement and ending block names do not match"));
        }
        return true;
    }

    Rule include() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.INCLUDE), new Object[]{this.mandatory(this.Sequence(this.basicParser.stringLiteral(), this.basicParser.spacing(), new Object[]{this.push(new Include((String)this.basicParser.pop())), this.closeCode()}), new ParseException("Wrong include syntax"))});
    }

    Rule text() {
        return this.Sequence(this.push(new Text()), this.OneOrMore(this.FirstOf(this.Sequence("{#", this.ZeroOrMore(this.TestNot("#}"), ANY, new Object[0]), new Object[]{"#}"}), this.Sequence(this.basicParser.escape(), ((Text)this.peek()).append(this.match()), new Object[0]), new Object[]{this.Sequence(this.TestNot(this.FirstOf(this.basicParser.symbol(JtwigSymbol.OPEN_OUTPUT), this.basicParser.symbol(JtwigSymbol.OPEN_CODE), new Object[0])), ANY, new Object[]{((Text)this.peek()).append(this.match())})})).suppressSubnodes(), new Object[0]);
    }

    Rule verbatim() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.VERBATIM), new Object[]{this.mandatory(this.Sequence(this.closeCode(), this.text(this.Sequence(this.openCode(), this.keyword(JtwigKeyword.ENDVERBATIM), new Object[0])), new Object[]{this.openCode(), this.keyword(JtwigKeyword.ENDVERBATIM), this.closeCode()}), new ParseException("Wrong verbatim syntax"))});
    }

    Rule text(Rule until) {
        return this.Sequence(this.push(new Text()), this.OneOrMore(this.FirstOf(this.Sequence(this.basicParser.escape(), ((Text)this.peek()).append(this.match()), new Object[0]), this.Sequence(this.TestNot(until), ANY, new Object[]{((Text)this.peek()).append(this.match())}), new Object[0])).suppressSubnodes(), new Object[0]);
    }

    Rule ifCondition() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.IF), new Object[]{this.mandatory(this.Sequence(this.expressionParser.expression(), this.closeCode(), new Object[]{this.push(new IfExpression((Expression)this.expressionParser.pop())), this.content(), ((IfExpression)this.peek(1)).setContent((Content)this.pop()), this.ZeroOrMore(this.Sequence(this.openCode(), this.keyword(JtwigKeyword.ELSEIF), new Object[]{this.expressionParser.expression(), this.push(new IfExpression.ElseIfExpression((Expression)this.expressionParser.pop())), this.closeCode(), this.content(), ((IfExpression.ElseIfExpression)this.peek(1)).setContent((Content)this.pop()), ((IfExpression)this.peek(1)).addElseIf((IfExpression.ElseIfExpression)this.pop())})), this.Optional(this.Sequence(this.openCode(), this.keyword(JtwigKeyword.ELSE), new Object[]{this.closeCode(), this.content(), ((IfExpression)this.peek(1)).setElseExpression(new IfExpression.ElseExpression((JtwigContent)this.pop()))})), this.openCode(), this.keyword(JtwigKeyword.ENDIF), this.closeCode()}), new ParseException("Wrong if syntax"))});
    }

    Rule forEach() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.FOR), new Object[]{this.mandatory(this.Sequence(this.expressionParser.variable(), this.FirstOf(this.Sequence(this.symbol(JtwigSymbol.COMMA), this.expressionParser.variable(), new Object[]{this.keyword(JtwigKeyword.IN), this.expressionParser.expression(), this.push(new ForPairLoop((Variable)this.expressionParser.pop(2), (Variable)this.expressionParser.pop(1), (Expression)this.expressionParser.pop()))}), this.Sequence(this.keyword(JtwigKeyword.IN), this.expressionParser.expression(), new Object[]{this.push(new ForLoop((Variable)this.expressionParser.pop(1), (Expression)this.expressionParser.pop()))}), new Object[0]), new Object[]{this.closeCode(), this.content(), ((ForLoop)this.peek(1)).setContent((Content)this.pop()), this.openCode(), this.keyword(JtwigKeyword.ENDFOR), this.closeCode()}), new ParseException("Wrong for each syntax"))});
    }

    Rule set() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.SET), new Object[]{this.mandatory(this.Sequence(this.expressionParser.variable(), this.push(new SetVariable((Variable)this.expressionParser.pop())), new Object[]{this.symbol(JtwigSymbol.ATTR), this.expressionParser.expression(), ((SetVariable)this.peek(1)).setAssignment((Expression)this.expressionParser.pop()), this.closeCode()}), new ParseException("Wrong set syntax"))});
    }

    Rule output() {
        return this.Sequence(this.symbol(JtwigSymbol.OPEN_OUTPUT), this.mandatory(this.Sequence(this.expressionParser.expression(), this.push(new Output((Expression)this.expressionParser.pop())), new Object[]{this.basicParser.symbol(JtwigSymbol.CLOSE_OUTPUT)}), new ParseException("Wrong output syntax")), new Object[0]);
    }

    Rule symbol(JtwigSymbol symbol) {
        return this.Sequence(this.basicParser.symbol(symbol), this.basicParser.spacing(), new Object[0]);
    }

    Rule mandatory(Rule rule, ParseException exception) {
        return this.FirstOf(rule, this.throwException(exception), new Object[0]);
    }

    boolean throwException(ParseException exception) throws ParseBypassException {
        throw new ParseBypassException(exception);
    }

    Rule openCode() {
        return this.Sequence(this.basicParser.openCode(), this.basicParser.spacing(), new Object[0]);
    }

    Rule keyword(JtwigKeyword keyword) {
        return this.Sequence(this.basicParser.keyword(keyword), this.basicParser.spacing(), new Object[0]);
    }

    Rule closeCode() {
        return this.basicParser.closeCode();
    }
}

