/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser;

import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.parser.JtwigBasicParser;
import com.lyncode.jtwig.parser.JtwigConstantParser;
import com.lyncode.jtwig.parser.JtwigKeyword;
import com.lyncode.jtwig.parser.JtwigSymbol;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.Constant;
import com.lyncode.jtwig.tree.expressions.FunctionElement;
import com.lyncode.jtwig.tree.expressions.MapSelection;
import com.lyncode.jtwig.tree.expressions.OperationBinary;
import com.lyncode.jtwig.tree.expressions.OperationTernary;
import com.lyncode.jtwig.tree.expressions.OperationUnary;
import com.lyncode.jtwig.tree.expressions.Operator;
import com.lyncode.jtwig.tree.expressions.ValueList;
import com.lyncode.jtwig.tree.expressions.ValueMap;
import com.lyncode.jtwig.tree.expressions.Variable;
import com.lyncode.jtwig.util.Simplifier;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.SuppressNode;

public class JtwigExpressionParser
extends BaseParser<Expression> {
    JtwigBasicParser basic = (JtwigBasicParser)Parboiled.createParser(JtwigBasicParser.class, (Object[])new Object[0]);
    JtwigConstantParser constants = (JtwigConstantParser)Parboiled.createParser(JtwigConstantParser.class, (Object[])new Object[0]);

    public Rule expression() {
        return this.Sequence(this.specificJtwigOperators(), this.push(Simplifier.simplify((Expression)this.pop())), new Object[0]);
    }

    Rule specificJtwigOperators() {
        return this.binary(this.orExpression(), Operator.STARTS_WITH, Operator.ENDS_WITH, Operator.MATCHES, Operator.IN);
    }

    protected Rule orExpression() {
        return this.binary(this.andExpression(), Operator.OR);
    }

    Rule andExpression() {
        return this.binary(this.equalityExpression(), Operator.AND);
    }

    Rule equalityExpression() {
        return this.binary(this.relationalExpression(), Operator.EQUAL, Operator.DIFF);
    }

    Rule relationalExpression() {
        return this.binary(this.FirstOf(this.negation(), this.addition(), new Object[]{this.negative()}), Operator.LTE, Operator.GTE, Operator.LT, Operator.GT);
    }

    Rule negation() {
        return this.unary(this.addition(), Operator.NOT);
    }

    Rule negative() {
        return this.unary(this.addition(), Operator.SUB);
    }

    Rule addition() {
        return this.binary(this.multiplication(), Operator.ADD, Operator.SUB);
    }

    Rule multiplication() {
        return this.binary(this.composition(), Operator.INT_DIV, Operator.INT_TIMES, Operator.TIMES, Operator.DIV, Operator.MOD);
    }

    Rule composition() {
        return this.binary(this.selection(), this.FirstOf(this.functionWithBrackets(), this.variable(), new Object[0]), Operator.COMPOSITION);
    }

    Rule selection() {
        return this.binary(this.isOperation(), this.FirstOf(this.functionWithBrackets(), this.mapEntry(), new Object[]{this.variable()}), Operator.SELECTION);
    }

    Rule isOperation() {
        return this.Sequence(this.primary(), this.push(new OperationBinary(Simplifier.simplify((Expression)this.pop()))), new Object[]{this.ZeroOrMore(this.operator(Operator.IS), this.popValue(), new Object[]{this.mandatory(this.Sequence(this.FirstOf(this.Sequence(this.operator(Operator.NOT), this.popValue(), new Object[]{((OperationBinary)this.peek()).addOperator(Operator.IS_NOT)}), ((OperationBinary)this.peek()).addOperator(Operator.IS), new Object[0]), this.FirstOf(this.functionWithBrackets(), this.functionWithTwoWordsAsName(), new Object[]{this.variable(), this.keywordAsVariable(JtwigKeyword.NULL)}), new Object[]{((OperationBinary)this.peek(1)).add(Simplifier.simplify((Expression)this.pop()))}), new ParseException("Wrong binary operation syntax"))})});
    }

    Rule primary() {
        return this.FirstOf(this.ternaryOperation(), this.elementar(), new Object[0]);
    }

    Rule ternaryOperation() {
        return this.Sequence(this.elementar(), this.push(new OperationTernary((Expression)this.pop())), new Object[]{this.symbol(JtwigSymbol.QUESTION), this.mandatory(this.Sequence(this.expression(), ((OperationTernary)this.peek(1)).setIfTrueExpression((Expression)this.pop()), new Object[]{this.symbol(JtwigSymbol.DIV), this.expression(), ((OperationTernary)this.peek(1)).setIfFalseExpression((Expression)this.pop())}), new ParseException("Wring ternary operation syntax"))});
    }

    Rule elementar() {
        return this.FirstOf(this.mapEntry(), this.function(), new Object[]{this.map(), this.list(), this.variable(), this.constant(), this.Sequence(this.symbol(JtwigSymbol.OPEN_PARENT), this.expression(), new Object[]{this.symbol(JtwigSymbol.CLOSE_PARENT)})});
    }

    Rule mapEntry() {
        return this.Sequence(this.variable(), this.symbol(JtwigSymbol.OPEN_BRACKET), new Object[]{this.mandatory(this.Sequence(this.expression(), this.symbol(JtwigSymbol.CLOSE_BRACKET), new Object[]{this.push(new MapSelection((Variable)this.pop(1), (Expression)this.pop()))}), new ParseException("Wring map selection syntax"))});
    }

    Rule function() {
        return this.FirstOf(this.functionWithBrackets(), this.functionWithoutBrackets(), new Object[0]);
    }

    Rule functionWithTwoWordsAsName() {
        return this.Sequence(this.variable(), this.variable(), new Object[]{this.push(new FunctionElement(this.popVariableName(1) + " " + this.popVariableName())), this.mandatory(this.Sequence(this.expression(), ((FunctionElement)this.peek(1)).add((Expression)this.pop()), new Object[0]), new ParseException("Wrong function named with two words syntax"))});
    }

    Rule functionWithoutBrackets() {
        return this.Sequence(this.variable(), this.TestNot(this.basic.spacing(), this.basic.terminal(Operator.SUB.toString()), new Object[0]), new Object[]{this.expression(), this.push(new FunctionElement(this.popVariableName(1), (Expression)this.pop()))});
    }

    Rule functionWithBrackets() {
        return this.Sequence(this.variable(), this.symbol(JtwigSymbol.OPEN_PARENT), new Object[]{this.push(new FunctionElement(this.popVariableName())), this.mandatory(this.Sequence(this.expression(), ((FunctionElement)this.peek(1)).add((Expression)this.pop()), new Object[]{this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.expression(), new Object[]{((FunctionElement)this.peek(1)).add((Expression)this.pop())}), this.symbol(JtwigSymbol.CLOSE_PARENT)}), new ParseException("Wrong function syntax"))});
    }

    Rule map() {
        return this.Sequence(this.symbol(JtwigSymbol.OPEN_CURLY_BRACKET), this.push(new ValueMap()), new Object[]{this.mandatory(this.Sequence(this.Optional(this.variable(), this.symbol(JtwigSymbol.DIV), new Object[]{this.expression(), ((ValueMap)this.peek(2)).add(this.popVariableName(1), this.pop()), this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.variable(), new Object[]{this.symbol(JtwigSymbol.DIV), this.expression(), ((ValueMap)this.peek(2)).add(this.popVariableName(1), this.pop())})}), this.symbol(JtwigSymbol.CLOSE_CURLY_BRACKET), new Object[0]), new ParseException("Wrong map syntax"))});
    }

    Rule list() {
        return this.FirstOf(this.comprehensionList(), this.enumeratedList(), new Object[0]);
    }

    Rule enumeratedList() {
        return this.Sequence(this.symbol(JtwigSymbol.OPEN_BRACKET), this.push(new ValueList()), new Object[]{this.mandatory(this.Sequence(this.Optional(this.expression(), ((ValueList)this.peek(1)).add((Expression)this.pop()), new Object[]{this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.expression(), new Object[]{((ValueList)this.peek(1)).add((Expression)this.pop())})}), this.symbol(JtwigSymbol.CLOSE_BRACKET), new Object[0]), new ParseException("Wrong list syntax"))});
    }

    Rule comprehensionList() {
        return this.Sequence(this.constants.anyConstant(), this.basic.symbol(JtwigSymbol.TWO_DOTS), new Object[]{this.constants.anyConstant(), this.push(ValueList.create((Constant)this.constants.pop(1), (Constant)this.constants.pop())), this.basic.spacing()});
    }

    Rule variable() {
        return this.Sequence(this.basic.identifier(), this.push(new Variable(this.match())), new Object[]{this.basic.spacing()});
    }

    Rule constant() {
        return this.Sequence(this.constants.anyConstant(), this.push(this.constants.pop()), new Object[]{this.basic.spacing()});
    }

    Rule mandatory(Rule rule, ParseException exception) {
        return this.FirstOf(rule, this.throwException(exception), new Object[0]);
    }

    boolean throwException(ParseException exception) throws ParseBypassException {
        throw new ParseBypassException(exception);
    }

    Rule symbol(JtwigSymbol symbol) {
        return this.Sequence(this.basic.symbol(symbol), this.basic.spacing(), new Object[0]);
    }

    Rule keywordAsVariable(JtwigKeyword keyword) {
        return this.Sequence(this.basic.keyword(keyword), this.push(new Variable(this.basic.match())), new Object[]{this.basic.spacing()});
    }

    @SuppressNode
    Rule firstOperatorOf(Operator ... operators) {
        Object[] rules = new Rule[operators.length];
        int i = 0;
        for (Operator operator : operators) {
            rules[i++] = this.operator(operator);
        }
        return this.FirstOf(rules);
    }

    Rule operator(Operator operator) {
        return this.Sequence(this.TestNot(this.FirstOf(this.basic.closeCode(), this.basic.symbol(JtwigSymbol.CLOSE_OUTPUT), new Object[0])), this.basic.terminal(operator.toString()), new Object[]{this.conditionalSpace(operator.toString()), this.push(new Constant<Operator>(operator)), this.basic.spacing()});
    }

    Rule conditionalSpace(String string) {
        if (string.matches("[a-zA-Z_$][a-zA-Z0-9_$]*")) {
            return this.AnyOf(" \t\r\n\f");
        }
        return this.Test(true);
    }

    Rule binary(Rule first, Rule rest, Operator ... operators) {
        return this.Sequence(first, this.push(new OperationBinary(Simplifier.simplify((Expression)this.pop()))), new Object[]{this.ZeroOrMore(this.firstOperatorOf(operators), ((OperationBinary)this.peek(1)).addOperator((Operator)((Object)((Constant)this.pop()).getValue())), new Object[]{this.mandatory(this.Sequence(rest, ((OperationBinary)this.peek(1)).add(Simplifier.simplify((Expression)this.pop())), new Object[0]), new ParseException("Wrong binary operation syntax"))})});
    }

    Rule binary(Rule innerExpression, Operator ... operators) {
        return this.binary(innerExpression, innerExpression, operators);
    }

    Rule unary(Rule innerRule, Operator ... operators) {
        return this.Sequence(this.firstOperatorOf(operators), this.push(new OperationUnary((Operator)((Object)((Constant)this.pop()).getValue()))), new Object[]{this.mandatory(this.Sequence(innerRule, ((OperationUnary)this.peek(1)).setOperand(Simplifier.simplify((Expression)this.pop())), new Object[0]), new ParseException("Wrong unary operator syntax"))});
    }

    protected String popVariableName(int i) {
        return ((Variable)this.pop(i)).getIdentifier();
    }

    protected String popVariableName() {
        return this.popVariableName(0);
    }

    boolean popValue() {
        this.pop();
        return true;
    }
}

