(ns clj-euler.bitops
  (:refer-clojure :exclude
    (bit-and bit-or bit-not bit-xor bit-shift-right bit-shift-left))
  (:import
    [clojure.lang BigInt]
    [java.math BigInteger]))

(defn- bigint?
  [n]
  (or (instance? BigInt n)
      (instance? BigInteger n)))

(defn- embiggen
  [n]
  (.toBigInteger (bigint n)))

(defn bit-and
  [a b]
  (if (or (bigint? a) (bigint? b))
    (let [a' (embiggen a)
          b' (embiggen b)]
      (.and ^BigInteger a' b'))
      (clojure.core/bit-and a b)))

(defn bit-or
  [a b]
  (if (or (bigint? a) (bigint? b))
    (let [a' (embiggen a)
          b' (embiggen b)]
      (.or ^BigInteger a' b'))
      (clojure.core/bit-or a b)))

(defn bit-not
  [a]
  (if (bigint? a)
    (-> ^BigInt a (.toBigInteger) (.not))
    (clojure.core/bit-not a)))

(defn bit-xor
  [a b]
  (if (or (bigint? a) (bigint? b))
    (let [a' (embiggen a)
          b' (embiggen b)]
      (.xor ^BigInteger a' b'))
      (clojure.core/bit-xor a b)))

(defn bit-shift-left
  [a b]
  (if (bigint? a)
    (.shiftLeft ^BigInteger (embiggen a) b)
    (clojure.core/bit-shift-left a b)))

(defn bit-shift-right
  [a b]
  (if (bigint? a)
    (.shiftRight ^BigInteger (embiggen a) b)
    (clojure.core/bit-shift-right a b)))
