(ns debug.core)

(defmacro dbg-defn-brief [_ nam vars & body]
  `(defn ~nam ~vars
     (println '~nam "start")
     (let [x# (do ~@body)]
       (println '~nam "end")
       x#)))

(defmacro dbg-brief [fun & body]
  `(do (println '~fun "reached")
       (let [x# (~fun ~@body)]
         (println '~fun "exited")
         (if (seq? x#)
           (detect-end (fn [] (println '~fun "forced")) x#)
           x#))))

(defmacro dbg-defn [_ nam vars & body]
  `(defn ~nam ~vars
     (println '~nam "start" ~vars)
     (let [x# (do ~@body)]
       (println '~nam "end val=" x#)
       x#)))

(defmacro dbg-fn [nam vars & body]
  `(fn ~vars
     (println "fn start" ~vars)
     (let [x# (do ~@body)]
       (println "fn end val=" x#)
       x#)))

(defmacro dbg-fun [fun & body]
  `(do (println '~fun "reached")
       (let [x# (~fun ~@body)]
         (println '~fun "exited val=" x#)
           x#)))

(defmacro dbg-var [nam var]
  `(let [x# ~var]
     (println ~nam "=*" x# "*")
     x#))

(defn dbg-lbl [lbl]
  (println "{" lbl "}"))

(defmacro dbg [& body]
   (cond (= (first body) :brief) (if (= (second body) 'defn)
                                   `(dbg-defn-brief ~@(next body))
                                   `(dbg-brief ~@(next body)))
         (and (seq? (first body)) (= (first (first body)) 'quote)) `(dbg-var '~(second (first body)) ~(second (first body)))
         (string? (first body)) `(dbg-lbl ~(first body))
         (= (first body) 'defn) `(dbg-defn ~@body)
         (= (first body) 'fn) `(dbg-fn ~@body)
         true `(dbg-fun ~@body)))
