(ns com.lispcast.number-cruncher
  (:gen-class
   :name com.lispcast.NumberCruncher
   :state state
   :init init
   :implements [Iterable]
   :methods [[average [Number] void]])
  (:require [clojure.core.async :as async]))

(defn -init []
  [[] {:atom (atom [0 0])
       :chan (async/chan (async/dropping-buffer 100))}])

(defn average-in [[n d] x]
  [(+ n x) (inc d)])

(defn average [a c x]
  (let [[n d] (swap! a average-in x)]
    (async/put! c (double (/ n d)))))

(defn -average [this x]
  (let [{:keys [atom chan]} (.-state this)]
    (average atom chan x))
  nil)

(defn blocking-channel-iterator [chan]
  (lazy-seq
   (let [v (async/<!! chan)]
     (if (nil? v) ;; it's closed
       nil
       (cons v (blocking-channel-iterator chan))))))

(defn -iterator [this]
  (clojure.lang.SeqIterator.
   (blocking-channel-iterator (:chan (.-state this)))))



