/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MergeableExponentiallyDecayingReservoir {
    public static final int DEFAULT_SIZE = 1028;
    public static final double DEFAULT_ALPHA = 0.015;
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private static final long CURRENT_NEXT_SCALE_TIME = Long.MIN_VALUE;
    private final ConcurrentSkipListMap<Double, Double> _values = new ConcurrentSkipListMap();
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private final double _alpha;
    private final int _size;
    private final AtomicLong _count;
    private volatile long _startTime;
    private final AtomicLong _nextScaleTime;
    private final Clock _clock;

    public MergeableExponentiallyDecayingReservoir() {
        this(1028, 0.015);
    }

    public MergeableExponentiallyDecayingReservoir(int size, double alpha) {
        this(size, alpha, Clock.defaultClock());
    }

    public MergeableExponentiallyDecayingReservoir(int size, double alpha, Clock clock) {
        this._alpha = alpha;
        this._size = size;
        this._clock = clock;
        this._count = new AtomicLong(0L);
        this._startTime = this.currentTimeInSeconds();
        this._nextScaleTime = new AtomicLong(clock.getTick() + RESCALE_THRESHOLD);
    }

    public int size() {
        return (int)Math.min((long)this._size, this._count.get());
    }

    public void update(double value) {
        this.update(value, this.currentTimeInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(double value, long timestamp) {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            double priority = this.weight(timestamp - this._startTime) / ThreadLocalRandom.current().nextDouble();
            long newCount = this._count.incrementAndGet();
            if (newCount <= (long)this._size) {
                this._values.put(priority, value);
            } else {
                Double first = this._values.firstKey();
                if (first < priority && this._values.putIfAbsent(priority, value) == null) {
                    while (this._values.remove(first) == null) {
                        first = this._values.firstKey();
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergeableExponentiallyDecayingReservoir other) {
        if (other == null) {
            return;
        }
        ConcurrentNavigableMap<Double, Double> otherReversedMap = null;
        long now = this._clock.getTick();
        long otherStartTime = other.getLandmark();
        if (otherStartTime < this._startTime) {
            otherReversedMap = other.rescale(now, Long.MIN_VALUE, this._startTime);
        } else {
            otherReversedMap = other.getDescendingMap();
            if (otherStartTime > this._startTime) {
                this.rescale(now, this._nextScaleTime.get(), otherStartTime);
            }
        }
        this.lockForRegularUsage();
        try {
            long trueCount;
            long approxCount = this._count.get();
            for (Double priority : otherReversedMap.keySet()) {
                Double value = (Double)otherReversedMap.get(priority);
                if (++approxCount <= (long)this._size) {
                    this._values.put(priority, value);
                    continue;
                }
                Double lowestPriority = this._values.firstKey();
                if (!(lowestPriority < priority)) break;
                if (this._values.putIfAbsent(priority, value) != null) continue;
                while (this._values.remove(lowestPriority) == null) {
                    lowestPriority = this._values.firstKey();
                }
            }
            if ((trueCount = (long)this._values.size()) > (long)this._size) {
                for (long i = (long)this._size; i < trueCount; ++i) {
                    Double lowestPriority = this._values.firstKey();
                    while (this._values.remove(lowestPriority) == null) {
                        lowestPriority = this._values.firstKey();
                    }
                }
                trueCount = this._size;
            }
            this._count.set(trueCount);
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLandmark() {
        this.lockForRegularUsage();
        try {
            long l = this._startTime;
            return l;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentNavigableMap<Double, Double> getDescendingMap() {
        this.lockForRegularUsage();
        try {
            NavigableMap navigableMap = this._values.descendingMap();
            return navigableMap;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getUnsortedValues() {
        this.lockForRegularUsage();
        try {
            Collection<Double> dataValues = this._values.values();
            double[] result = new double[dataValues.size()];
            int j = 0;
            for (Double dataValue : dataValues) {
                result[j++] = dataValue;
            }
            double[] dArray = result;
            return dArray;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this._clock.getTime());
    }

    private double weight(long t) {
        return Math.exp(this._alpha * (double)t);
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this._clock.getTick();
        if (now >= (next = this._nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this._nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this._startTime;
                this._startTime = this.currentTimeInSeconds();
                ArrayList keys = new ArrayList(this._values.keySet());
                for (Double key : keys) {
                    Double value = this._values.remove(key);
                    this._values.put(key * Math.exp(-this._alpha * (double)(this._startTime - oldStartTime)), value);
                }
                this._count.set(this._values.size());
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentNavigableMap<Double, Double> rescale(long now, long next, long startTime) {
        if (next == Long.MIN_VALUE) {
            next = this._nextScaleTime.get();
        }
        if (this._nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this._startTime;
                this._startTime = startTime;
                ArrayList keys = new ArrayList(this._values.keySet());
                for (Double key : keys) {
                    Double value = this._values.remove(key);
                    this._values.put(key * Math.exp(-this._alpha * (double)(this._startTime - oldStartTime)), value);
                }
                NavigableMap navigableMap = this._values.descendingMap();
                return navigableMap;
            }
            finally {
                this.unlockForRescale();
            }
        }
        this.lockForRegularUsage();
        try {
            NavigableMap navigableMap = this._values.descendingMap();
            return navigableMap;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private void lockForRescale() {
        this._lock.writeLock().lock();
    }

    private void unlockForRescale() {
        this._lock.writeLock().unlock();
    }

    private void lockForRegularUsage() {
        this._lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this._lock.readLock().unlock();
    }
}

