/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay.util.test;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.BackoffTimerStaticConfigBuilder;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.relay.DatabusRelayMain;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class DatabusRelayTestUtil {
    public static final String MODULE = DatabusRelayTestUtil.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static DbusEventBuffer.Config createBufferConfig(long eventBufferMaxSize, int readBufferSize, int scnIndexSize) {
        DbusEventBuffer.Config bconf = new DbusEventBuffer.Config();
        bconf.setMaxSize(eventBufferMaxSize);
        bconf.setAverageEventSize(readBufferSize);
        bconf.setScnIndexSize(scnIndexSize);
        bconf.setAllocationPolicy("DIRECT_MEMORY");
        return bconf;
    }

    public static ServerContainer.Config createContainerConfig(int id, int httpPort) {
        ServerContainer.Config sconf = new ServerContainer.Config();
        sconf.setHealthcheckPath("/admin");
        sconf.setHttpPort(httpPort);
        sconf.setId(id);
        sconf.getJmx().setRmiEnabled(false);
        int threadNum = Math.max(Runtime.getRuntime().availableProcessors() / 2, 3);
        sconf.getRuntime().getDefaultExecutor().setCoreThreadsNum(threadNum);
        sconf.getRuntime().getDefaultExecutor().setMaxThreadsNum(threadNum);
        return sconf;
    }

    public static String getPhysicalSrcName(String s) {
        String[] cmpt = s.split("\\.");
        String name = cmpt.length >= 4 ? cmpt[3] : s;
        return name;
    }

    public static PhysicalSourceConfig createPhysicalConfigBuilder(short id, String name, String uri, long pollIntervalMs, int eventRatePerSec, String[] logicalSources) {
        return DatabusRelayTestUtil.createPhysicalConfigBuilder(id, name, uri, pollIntervalMs, eventRatePerSec, 0L, 0x100000, 0x500000L, logicalSources);
    }

    public static PhysicalSourceConfig createPhysicalConfigBuilder(short id, String name, String uri, long pollIntervalMs, int eventRatePerSec, long restartScnOffset, int largestEventSize, long largestWindowSize, String[] logicalSources) {
        LogicalSourceConfig[] lSourceConfigs = new LogicalSourceConfig[logicalSources.length];
        short lid = (short)(id + 1);
        int i = 0;
        for (String schemaName : logicalSources) {
            LogicalSourceConfig lConf = new LogicalSourceConfig();
            short s = lid;
            lid = (short)(lid + 1);
            lConf.setId(s);
            lConf.setName(schemaName);
            lConf.setUri(schemaName);
            lConf.setPartitionFunction("constant:1");
            lSourceConfigs[i] = lConf;
            ++i;
        }
        return DatabusRelayTestUtil.createPhysicalConfigBuilder(id, name, uri, pollIntervalMs, eventRatePerSec, restartScnOffset, largestEventSize, largestWindowSize, lSourceConfigs);
    }

    public static PhysicalSourceConfig createPhysicalConfigBuilder(short id, String name, String uri, long pollIntervalMs, int eventRatePerSec, long restartScnOffset, int largestEventSize, long largestWindowSize, LogicalSourceConfig[] lSourceConfigs) {
        PhysicalSourceConfig pConfig = new PhysicalSourceConfig();
        pConfig.setId((int)id);
        pConfig.setName(name);
        pConfig.setUri(uri);
        pConfig.setEventRatePerSec((long)eventRatePerSec);
        pConfig.setRestartScnOffset(restartScnOffset);
        pConfig.setLargestEventSizeInBytes(largestEventSize);
        pConfig.setLargestWindowSizeInBytes(largestWindowSize);
        BackoffTimerStaticConfigBuilder retriesConf = new BackoffTimerStaticConfigBuilder();
        retriesConf.setInitSleep(pollIntervalMs);
        pConfig.setRetries(retriesConf);
        for (LogicalSourceConfig lConf : lSourceConfigs) {
            pConfig.addSource(lConf);
        }
        return pConfig;
    }

    public static LogicalSourceConfig createLogicalSourceConfig(short logicalSourceId, String logicalSourceName, String logicalSourceUri, String logicalPartitionFunction) {
        LogicalSourceConfig lconf = new LogicalSourceConfig();
        lconf.setId(logicalSourceId);
        lconf.setName(logicalSourceName);
        lconf.setUri(logicalSourceUri);
        lconf.setPartitionFunction(logicalPartitionFunction);
        return lconf;
    }

    public static HttpRelay.Config createHttpRelayConfig(int relayId, int httpPort, long maxBufferSize) throws IOException {
        HttpRelay.Config httpRelayConfig = new HttpRelay.Config();
        ServerContainer.Config containerConfig = DatabusRelayTestUtil.createContainerConfig(relayId, httpPort);
        DbusEventBuffer.Config bufferConfig = DatabusRelayTestUtil.createBufferConfig(maxBufferSize, DatabusRelayTestUtil.safeLongToInt(maxBufferSize / 10L), DatabusRelayTestUtil.safeLongToInt(Math.max(maxBufferSize / 256L, 256L)));
        httpRelayConfig.setContainer(containerConfig);
        httpRelayConfig.setEventBuffer(bufferConfig);
        httpRelayConfig.setStartDbPuller("true");
        return httpRelayConfig;
    }

    public static int getRandomRelayId() {
        return -1;
    }

    private static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }

    public static void setSchemaRegistryLocation(HttpRelay.Config relayHttpConfig, String schemaRegistryLocation) {
        relayHttpConfig.getSchemaRegistry().getFileSystem().setSchemaDir(schemaRegistryLocation);
    }

    public static DatabusRelayMain createDatabusRelay(int relayId, int httpPort, long maxBufferSize, PhysicalSourceConfig[] sourceConfigs) {
        try {
            HttpRelay.Config httpRelayConfig = DatabusRelayTestUtil.createHttpRelayConfig(relayId, httpPort, maxBufferSize);
            return DatabusRelayTestUtil.createDatabusRelay(sourceConfigs, httpRelayConfig);
        }
        catch (IOException e) {
            LOG.error((Object)("IO Exception " + e));
        }
        catch (InvalidConfigException e) {
            LOG.error((Object)("Invalid config " + (Object)((Object)e)));
        }
        catch (DatabusException e) {
            LOG.error((Object)("Databus Exception " + (Object)((Object)e)));
        }
        return null;
    }

    public static DatabusRelayMain createDatabusRelayWithSchemaReg(int relayId, int httpPort, long maxBufferSize, PhysicalSourceConfig[] sourceConfigs, String schemRegPath) {
        try {
            HttpRelay.Config httpRelayConfig = DatabusRelayTestUtil.createHttpRelayConfig(relayId, httpPort, maxBufferSize);
            httpRelayConfig.getSchemaRegistry().getFileSystem().setSchemaDir(schemRegPath);
            return DatabusRelayTestUtil.createDatabusRelay(sourceConfigs, httpRelayConfig);
        }
        catch (IOException e) {
            LOG.error((Object)("IO Exception " + e));
        }
        catch (InvalidConfigException e) {
            LOG.error((Object)("Invalid config " + (Object)((Object)e)));
        }
        catch (DatabusException e) {
            LOG.error((Object)("Databus Exception " + (Object)((Object)e)));
        }
        return null;
    }

    public static DatabusRelayMain createDatabusRelay(PhysicalSourceConfig[] sourceConfigs, HttpRelay.Config httpRelayConfig) throws IOException, DatabusException {
        PhysicalSourceStaticConfig[] pStaticConfigs = new PhysicalSourceStaticConfig[sourceConfigs.length];
        int i = 0;
        for (PhysicalSourceConfig pConf : sourceConfigs) {
            for (LogicalSourceConfig lsc : pConf.getSources()) {
                httpRelayConfig.setSourceName("" + lsc.getId(), lsc.getName());
            }
            pStaticConfigs[i++] = pConf.build();
        }
        DatabusRelayMain relayMain = new DatabusRelayMain(httpRelayConfig.build(), pStaticConfigs);
        return relayMain;
    }

    public static class RelayRunner
    extends Thread {
        private final DatabusRelayMain _relay;

        public RelayRunner(DatabusRelayMain relay) {
            this._relay = relay;
        }

        @Override
        public void run() {
            try {
                this._relay.initProducers();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception ", (Throwable)e);
                return;
            }
            this._relay.startAsynchronously();
        }

        public void pause() {
            this._relay.pause();
        }

        public void unpause() {
            this._relay.resume();
        }

        public boolean shutdown(int timeoutMs) {
            this._relay.shutdown();
            try {
                if (timeoutMs > 0) {
                    this._relay.awaitShutdown(timeoutMs);
                } else {
                    this._relay.awaitShutdown();
                }
            }
            catch (TimeoutException e) {
                LOG.error((Object)("Not shutdown in " + timeoutMs + " ms"));
                return false;
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Interrupted before " + timeoutMs + " ms"));
                return true;
            }
            return true;
        }

        public DatabusRelayMain getRelay() {
            return this._relay;
        }
    }
}

