/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay;

import com.linkedin.databus.monitoring.mbean.DBStatistics;
import com.linkedin.databus.monitoring.mbean.DBStatisticsMBean;
import com.linkedin.databus.monitoring.mbean.SourceDBStatistics;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.relay.OracleJarUtils;
import com.linkedin.databus2.util.DBHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class MonitoringEventProducer
implements EventProducer,
Runnable {
    private final List<OracleTriggerMonitoredSourceInfo> _sources;
    private final String _name;
    private final String _dbname;
    MonitorState _state;
    private final HashMap<Short, String> _monitorQueriesBySource;
    protected static final long MAX_SCN_POLL_TIME = 600000L;
    protected static final long PER_SRC_MAX_SCN_POLL_TIME = 30000L;
    private Thread _curThread;
    private final String _uri;
    private final Logger _log = Logger.getLogger(this.getClass());
    private String _schema;
    private Connection _con;
    private DataSource _dataSource;
    private final DBStatistics _dbStats;
    private final MBeanServer _mbeanServer;

    public MonitoringEventProducer(String name, String dbname, String uri, List<OracleTriggerMonitoredSourceInfo> sources, MBeanServer mbeanServer) {
        this._sources = sources;
        this._name = name;
        this._dbname = dbname;
        this._state = MonitorState.INIT;
        this._con = null;
        this._dataSource = null;
        this._uri = uri;
        this._schema = null;
        this._mbeanServer = mbeanServer;
        this._monitorQueriesBySource = new HashMap();
        this._dbStats = new DBStatistics(dbname);
        for (OracleTriggerMonitoredSourceInfo sourceInfo : sources) {
            if (null == this._schema) {
                this._schema = sourceInfo.getEventSchema() == null ? "" : sourceInfo.getEventSchema() + ".";
                this._log.info((Object)("Reading source: _schema =  |" + this._schema + "|"));
            }
            this._dbStats.addSrcStats(new SourceDBStatistics(sourceInfo.getSourceName()));
            String eventQuery = this.generateEventQuery(sourceInfo);
            this._monitorQueriesBySource.put(sourceInfo.getSourceId(), eventQuery);
        }
        this._dbStats.registerAsMbean(this._mbeanServer);
        this._log.info((Object)("Created " + name + " producer "));
    }

    public String getName() {
        return this._name;
    }

    public long getSCN() {
        return 0L;
    }

    public DBStatisticsMBean getDBStats() {
        return this._dbStats;
    }

    public void unregisterMBeans() {
        this._dbStats.unregisterAsMbean(this._mbeanServer);
    }

    public synchronized void start(long sinceSCN) {
        if (this._state == MonitorState.INIT || this._state == MonitorState.SHUT) {
            this._state = MonitorState.RUNNING;
            this._curThread = new Thread(this);
            this._curThread.start();
        }
    }

    public synchronized boolean isRunning() {
        return this._state == MonitorState.RUNNING;
    }

    public synchronized boolean isPaused() {
        return false;
    }

    public synchronized void unpause() {
        this._state = MonitorState.RUNNING;
    }

    public synchronized void pause() {
    }

    public synchronized void shutdown() {
        this._state = MonitorState.SHUT;
    }

    protected boolean createDataSource() {
        try {
            if (this._dataSource == null) {
                this._dataSource = OracleJarUtils.createOracleDataSource(this._uri);
            }
        }
        catch (Exception e) {
            this._log.error((Object)"Error creating data source", (Throwable)e);
            this._dataSource = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.createDataSource() && this.openDbConn()) {
            do {
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    long maxDBScn = this.getMaxTxlogSCN(this._con);
                    this._log.info((Object)("Max DB Scn =  " + maxDBScn));
                    this._dbStats.setMaxDBScn(maxDBScn);
                    for (OracleTriggerMonitoredSourceInfo source : this._sources) {
                        String eventQuery = this._monitorQueriesBySource.get(source.getSourceId());
                        pstmt = this._con.prepareStatement(eventQuery);
                        pstmt.setFetchSize(10);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            long maxScn = rs.getLong(1);
                            this._log.info((Object)("Source: " + source.getSourceId() + " Max Scn=" + maxScn));
                            this._dbStats.setSrcMaxScn(source.getSourceName(), maxScn);
                        }
                        DBHelper.commit((Connection)this._con);
                        DBHelper.close((ResultSet)rs, (Statement)pstmt, null);
                        if (this._state == MonitorState.SHUT) continue;
                        Thread.sleep(30000L);
                    }
                    if (this._state == MonitorState.SHUT) continue;
                    Thread.sleep(600000L);
                }
                catch (InterruptedException e) {
                    this._log.error((Object)"Exception trace", (Throwable)e);
                    this.shutDown();
                }
                catch (SQLException e) {
                    try {
                        DBHelper.rollback((Connection)this._con);
                    }
                    catch (SQLException s) {
                        // empty catch block
                    }
                    this._log.error((Object)"Exception trace", (Throwable)e);
                    this.shutDown();
                }
                finally {
                    DBHelper.close(rs, pstmt, null);
                }
            } while (this._state != MonitorState.SHUT);
            this._log.info((Object)"Shutting down dbMonitor thread");
            DBHelper.close((Connection)this._con);
        }
    }

    protected synchronized void shutDown() {
        this._state = MonitorState.SHUT;
        this._curThread = null;
    }

    private String generateEventQuery(OracleTriggerMonitoredSourceInfo sourceInfo) {
        StringBuilder sql = new StringBuilder();
        sql.append("select  scn from ").append(this._schema).append("sy$txlog ");
        sql.append("where txn = ");
        sql.append(" ( select max(txn) from ").append(this._schema).append("sy$").append(sourceInfo.getEventView()).append(" )");
        this._log.info((Object)("Monitoring Query: " + sql.toString()));
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxTxlogSCN(Connection db) throws SQLException {
        long maxScn = -1L;
        String sql = "select max(" + this._schema + "sync_core.getScn(scn,ora_rowscn)) " + "from " + this._schema + "sy$txlog where " + "scn >= (select max(scn) from " + this._schema + "sy$txlog)";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = db.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxScn = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(rs, (Statement)pstmt, null);
            throw throwable;
        }
        DBHelper.close((ResultSet)rs, (Statement)pstmt, null);
        return maxScn;
    }

    protected boolean openDbConn() {
        if (this._dataSource == null) {
            return false;
        }
        try {
            if (this._con == null || this._con.isClosed()) {
                this._con = this._dataSource.getConnection();
                this._con.setAutoCommit(false);
                this._con.setTransactionIsolation(8);
            }
        }
        catch (SQLException e) {
            this._log.error((Object)"Exception trace", (Throwable)e);
            return false;
        }
        return true;
    }

    public void waitForShutdown() throws InterruptedException, IllegalStateException {
    }

    public void waitForShutdown(long arg0) throws InterruptedException, IllegalStateException {
    }

    protected static enum MonitorState {
        INIT,
        RUNNING,
        PAUSE,
        SHUT;

    }
}

