/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.gg;

import com.linkedin.databus2.ggParser.XmlStateMachine.ColumnsState;
import com.linkedin.databus2.ggParser.XmlStateMachine.DbUpdateState;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DBUpdatesMergeUtils {
    public static List<TransactionState.PerSourceTransactionalUpdate> mergeTransactionData(List<TransactionState.PerSourceTransactionalUpdate> newTxnDbUpdates, List<TransactionState.PerSourceTransactionalUpdate> oldDbUpdates) {
        if (null == oldDbUpdates && null == newTxnDbUpdates) {
            return null;
        }
        HashMap<Integer, TransactionState.PerSourceTransactionalUpdate> combinedTxnDbUpdatesMap = new HashMap<Integer, TransactionState.PerSourceTransactionalUpdate>();
        if (null != oldDbUpdates) {
            for (TransactionState.PerSourceTransactionalUpdate dbu : oldDbUpdates) {
                combinedTxnDbUpdatesMap.put(dbu.getSourceId(), dbu);
            }
        }
        if (null != newTxnDbUpdates) {
            for (TransactionState.PerSourceTransactionalUpdate dbu : newTxnDbUpdates) {
                TransactionState.PerSourceTransactionalUpdate oldDbu = (TransactionState.PerSourceTransactionalUpdate)combinedTxnDbUpdatesMap.get(dbu.getSourceId());
                if (null == oldDbu) {
                    combinedTxnDbUpdatesMap.put(dbu.getSourceId(), dbu);
                    continue;
                }
                Set<DbUpdateState.DBUpdateImage> mergeUpdateImages = DBUpdatesMergeUtils.mergeDbUpdates(dbu.getDbUpdatesSet(), oldDbu.getDbUpdatesSet());
                TransactionState.PerSourceTransactionalUpdate mergedPerSourceTxnUpdate = new TransactionState.PerSourceTransactionalUpdate(dbu.getSourceId(), mergeUpdateImages);
                combinedTxnDbUpdatesMap.put(dbu.getSourceId(), mergedPerSourceTxnUpdate);
            }
        }
        ArrayList<TransactionState.PerSourceTransactionalUpdate> sourceTransactionalUpdates = new ArrayList<TransactionState.PerSourceTransactionalUpdate>(combinedTxnDbUpdatesMap.size());
        for (Map.Entry entry : combinedTxnDbUpdatesMap.entrySet()) {
            sourceTransactionalUpdates.add((TransactionState.PerSourceTransactionalUpdate)entry.getValue());
        }
        Collections.sort(sourceTransactionalUpdates);
        return sourceTransactionalUpdates;
    }

    private static Set<DbUpdateState.DBUpdateImage> mergeDbUpdates(Set<DbUpdateState.DBUpdateImage> newDbUpdateImage, Set<DbUpdateState.DBUpdateImage> oldDbUpdateImage) {
        HashMap<ArrayList<ColumnsState.KeyPair>, DbUpdateState.DBUpdateImage> result = new HashMap<ArrayList<ColumnsState.KeyPair>, DbUpdateState.DBUpdateImage>();
        for (DbUpdateState.DBUpdateImage dbi : oldDbUpdateImage) {
            result.put(dbi.getKeyPairs(), dbi);
        }
        for (DbUpdateState.DBUpdateImage dbi : newDbUpdateImage) {
            result.put(dbi.getKeyPairs(), dbi);
        }
        return new HashSet<DbUpdateState.DBUpdateImage>(result.values());
    }
}

