/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.db;

import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.UnsupportedKeyException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.core.seq.MaxSCNWriter;
import com.linkedin.databus2.producers.AbstractEventProducer;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.producers.db.EventSourceStatisticsIface;
import com.linkedin.databus2.producers.db.OracleTriggerMonitoredSourceInfo;
import com.linkedin.databus2.producers.db.OracleTxlogEventReader;
import com.linkedin.databus2.producers.db.ReadEventCycleSummary;
import com.linkedin.databus2.producers.db.SourceDBEventReader;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;

public class OracleEventProducer
extends AbstractEventProducer {
    private final SourceDBEventReader _sourceDBEventReader;
    private ArrayList<ObjectName> _registeredMbeans;

    public OracleEventProducer(List<OracleTriggerMonitoredSourceInfo> sources, DataSource dataSource, DbusEventBufferAppendable eventBuffer, boolean enableTracing, DbusEventsStatisticsCollector dbusEventsStatisticsCollector, MaxSCNReaderWriter maxScnReaderWriter, PhysicalSourceStaticConfig physicalSourceConfig, MBeanServer mbeanServer) throws DatabusException {
        super(eventBuffer, maxScnReaderWriter, physicalSourceConfig, mbeanServer);
        this._registeredMbeans = new ArrayList(sources.size());
        for (OracleTriggerMonitoredSourceInfo source : sources) {
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("type", "SourceStatistics");
                props.put("name", source.getSourceName());
                ObjectName objectName = new ObjectName("com.linkedin.databus2", props);
                if (mbeanServer.isRegistered(objectName)) {
                    this._log.warn((Object)("Unregistering old source statistics mbean: " + objectName));
                    mbeanServer.unregisterMBean(objectName);
                }
                mbeanServer.registerMBean(source.getStatisticsBean(), objectName);
                this._log.info((Object)("Registered source statistics mbean: " + objectName));
                this._registeredMbeans.add(objectName);
            }
            catch (Exception ex) {
                this._log.error((Object)("Failed to register the source statistics mbean for source (" + source.getSourceName() + ") due to an exception."), (Throwable)ex);
                throw new DatabusException("Failed to initialize event statistics mbeans.", (Throwable)ex);
            }
        }
        this._sourceDBEventReader = new OracleTxlogEventReader(physicalSourceConfig.getName(), sources, dataSource, eventBuffer, enableTracing, dbusEventsStatisticsCollector, (MaxSCNWriter)maxScnReaderWriter, physicalSourceConfig.getSlowSourceQueryThreshold(), physicalSourceConfig.getChunkingType(), physicalSourceConfig.getTxnsPerChunk(), physicalSourceConfig.getScnChunkSize(), physicalSourceConfig.getChunkedScnThreshold(), physicalSourceConfig.getMaxScnDelayMs());
    }

    public List<? extends EventSourceStatisticsIface> getSources() {
        return this._sourceDBEventReader.getSources();
    }

    public List<OracleTriggerMonitoredSourceInfo> getMonitoredSourceInfos() {
        return this._sourceDBEventReader.getSources();
    }

    protected ReadEventCycleSummary readEventsFromAllSources(long sinceSCN) throws DatabusException, EventCreationException, UnsupportedKeyException {
        return this._sourceDBEventReader.readEventsFromAllSources(sinceSCN);
    }

    public synchronized void shutdown() {
        for (ObjectName name : this._registeredMbeans) {
            try {
                this._mbeanServer.unregisterMBean(name);
                this._log.info((Object)("Unregistered source mbean: " + name));
            }
            catch (MBeanRegistrationException e) {
                this._log.warn((Object)("Exception when unregistering source statistics mbean: " + name + e));
            }
            catch (InstanceNotFoundException e) {
                this._log.warn((Object)("Exception when unregistering source statistics mbean: " + name + e));
            }
        }
        super.shutdown();
    }

    public SourceDBEventReader getSourceDBReader() {
        return this._sourceDBEventReader;
    }
}

