/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers;

import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus.monitoring.mbean.EventSourceStatistics;
import com.linkedin.databus2.producers.db.EventReaderSummary;
import com.linkedin.databus2.producers.db.ReadEventCycleSummary;
import java.util.ArrayList;
import java.util.List;

public class RelayStatsAdapter {
    private DbusEventsStatisticsCollector _stats;
    private String _name;
    ReadEventCycleSummary _lastReadEventSummary = null;

    public RelayStatsAdapter(String name, DbusEventsStatisticsCollector statsCollector) {
        this._stats = statsCollector;
        this._name = name;
    }

    public synchronized ReadEventCycleSummary getReadEventCycleSummary() {
        ReadEventCycleSummary diff = null;
        if (this._stats != null) {
            ReadEventCycleSummary currentReadEventSummary = this.getReadEventSummary();
            if (this._lastReadEventSummary != null) {
                diff = this.getDiff(currentReadEventSummary, this._lastReadEventSummary);
                this._lastReadEventSummary = null;
            } else {
                diff = currentReadEventSummary;
            }
            this._lastReadEventSummary = currentReadEventSummary;
        }
        return diff;
    }

    protected ReadEventCycleSummary getReadEventSummary() {
        ArrayList<EventReaderSummary> sourceSummaries = new ArrayList<EventReaderSummary>();
        for (Integer srcId : this._stats.getSources()) {
            sourceSummaries.add(this.getSummary(srcId));
        }
        ReadEventCycleSummary summary = new ReadEventCycleSummary(this._name, sourceSummaries, this._stats.getTotalStats().getMaxScn(), System.currentTimeMillis());
        return summary;
    }

    protected EventReaderSummary getSummary(int sourceId) {
        DbusEventsTotalStats stats = this._stats.getSourceStats(sourceId);
        if (stats != null) {
            EventReaderSummary summary = new EventReaderSummary((short)sourceId, stats.getDimension(), stats.getMaxScn(), (int)stats.getNumDataEvents(), stats.getSizeDataEvents() * (long)((int)stats.getNumDataEvents()), System.currentTimeMillis(), 0L, this._stats.getTotalStats().getTimestampMinScnEvent(), stats.getTimestampMaxScnEvent(), 0L);
            return summary;
        }
        return null;
    }

    protected ReadEventCycleSummary getDiff(ReadEventCycleSummary src1, ReadEventCycleSummary src2) {
        List src1Summaries = src1.getSourceSummaries();
        List src2Summaries = src2.getSourceSummaries();
        if (src1Summaries.size() == src2Summaries.size()) {
            ArrayList<EventReaderSummary> sourceSummaries = new ArrayList<EventReaderSummary>();
            for (int i = 0; i < src1Summaries.size(); ++i) {
                sourceSummaries.add(this.getDiff((EventReaderSummary)src1Summaries.get(i), (EventReaderSummary)src2Summaries.get(i)));
            }
            ReadEventCycleSummary r1 = new ReadEventCycleSummary(src1.getEventSourceName(), sourceSummaries, src1.getEndOfWindowScn(), src1.getReadMillis() - src2.getReadMillis());
            return r1;
        }
        return null;
    }

    protected EventReaderSummary getDiff(EventReaderSummary s1, EventReaderSummary s2) {
        EventReaderSummary diff = new EventReaderSummary(s1.getSourceId(), s1.getSourceName(), s1.getEndOfPeriodSCN(), s1.getNumberOfEvents() - s2.getNumberOfEvents(), s1.getSizeOfSerializedEvents() - s2.getSizeOfSerializedEvents(), s1.getReadMillis() - s2.getReadMillis(), s1.getEventMillis(), s2.getTimeProdEnd(), s1.getTimeProdEnd(), s1.getQueryExecTime());
        return diff;
    }

    public synchronized EventSourceStatistics[] getEventSourceStatistics() {
        if (this._stats == null) {
            return null;
        }
        List sourceIds = this._stats.getSources();
        if (sourceIds.size() > 0) {
            EventSourceStatistics[] stats = new EventSourceStatistics[sourceIds.size()];
            int i = 0;
            for (Integer srcId : sourceIds) {
                EventSourceStatistics stat = this.getEventSourceStat(this._stats.getSourceStats(srcId.intValue()));
                stats[i++] = stat;
            }
            return stats;
        }
        return null;
    }

    protected EventSourceStatistics getEventSourceStat(DbusEventsTotalStats stats) {
        if (stats == null) {
            return null;
        }
        long numErrors = stats.getNumHeaderErrEvents() + stats.getNumPayloadErrEvents() + stats.getNumInvalidEvents();
        EventSourceStatistics eventStats = new EventSourceStatistics(this._name, (int)stats.getNumDataEvents(), stats.getTimeSinceLastAccess(), stats.getMaxScn(), numErrors, stats.getSizeDataEvents());
        return eventStats;
    }
}

