/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser.validator;

import com.linkedin.databus.core.ConcurrentAppendableCompositeFileInputStream;
import com.linkedin.databus.core.TrailFileNotifier;
import com.linkedin.databus.core.TrailFilePositionSetter;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.staxparser.validator.XmlFormatTrailParser;
import com.linkedin.databus2.producers.db.GGXMLTrailTransactionFinder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class XmlFormatTrailValidator {
    public static final Logger LOG = Logger.getLogger(XmlFormatTrailValidator.class);
    public static final String NAME = XmlFormatTrailValidator.class.getName();
    final TrailFilePositionSetter _trailFilePositionSetter;
    final TrailFilePositionSetter.FilePositionResult _filePositionResult;
    final TrailFileNotifier.TrailFileManager _filter;
    final ConcurrentAppendableCompositeFileInputStream _compositeInputStream;
    final XmlFormatTrailParser _parser;
    final boolean _continuous;
    final boolean _dtdValidationEnabled;
    final boolean _enableRegex;

    public XmlFormatTrailValidator(Cli cli) throws Exception {
        this(cli.getTrailDirName(), cli.getTrailFilePrefix(), cli.isContinuous(), cli.isDtdValidationEnabled(), cli.getErrorLogFName(), cli.getEnableRegex());
    }

    public XmlFormatTrailValidator(String xmlDir, String xmlPrefix, boolean continuous, boolean dtdValidationEnabled, String errorLogFName, boolean enableRegex) throws Exception {
        LOG.info((Object)("Reading " + xmlDir + "/" + xmlPrefix + "*; continuous=" + continuous + "; dtdValidation=" + dtdValidationEnabled + "; enableRegex=" + enableRegex));
        this._continuous = continuous;
        this._dtdValidationEnabled = dtdValidationEnabled;
        this._enableRegex = enableRegex;
        this._trailFilePositionSetter = new TrailFilePositionSetter(xmlDir, xmlPrefix);
        this._filePositionResult = this._trailFilePositionSetter.locateFilePosition(-2L, new GGXMLTrailTransactionFinder(this._enableRegex));
        LOG.info((Object)("starting from position " + this._filePositionResult));
        this._filter = new TrailFilePositionSetter.FileFilter(new File(xmlDir), xmlPrefix);
        this._compositeInputStream = new ConcurrentAppendableCompositeFileInputStream(xmlDir, this._filePositionResult.getTxnPos().getFile(), this._filePositionResult.getTxnPos().getFileOffset(), this._filter, !continuous);
        this._compositeInputStream.initializeStream();
        this._parser = new XmlFormatTrailParser(this._compositeInputStream, this._dtdValidationEnabled, null, errorLogFName);
    }

    public XmlFormatTrailValidator(String xmlDir, String xmlPrefix, boolean continuous, boolean dtdValidationEnabled, String errorLogFName) throws Exception {
        this(xmlDir, xmlPrefix, continuous, dtdValidationEnabled, errorLogFName, true);
    }

    public boolean run() throws IOException {
        boolean success = false;
        LOG.info((Object)"starting validation ...");
        if (this._continuous) {
            Thread runThread = new Thread((Runnable)this._parser, "XmlFormatTrailParser");
            runThread.start();
            success = true;
        } else {
            this._parser.run();
            Throwable error = this._parser.getLastError();
            LOG.info((Object)("validation complete: " + (null == error ? "SUCCESS" : error.toString())));
            if (null != error) {
                this._parser.printErrorContext(System.err);
            } else {
                success = true;
            }
            LOG.info((Object)("PARSE ERRORS: " + this._parser.getErrorCount()));
        }
        return success;
    }

    public static void main(String[] args) throws Exception {
        Cli cli = new Cli();
        if (!cli.processCommandLineArgs(args)) {
            return;
        }
        XmlFormatTrailValidator validator = new XmlFormatTrailValidator(cli);
        if (!validator.run()) {
            System.exit(255);
        }
    }

    private static class Cli {
        public static final char CONTINUOUS_OPT_CHAR = 'c';
        public static final char DEBUG_OPT_CHAR = 'd';
        public static final char DTD_VALIDATION_OPT_CHAR = 'D';
        public static final char USE_XPATH_QUERY_CHAR = 'x';
        public static final char HELP_OPT_CHAR = 'h';
        public static final char LOG4J_PROPS_OPT_CHAR = 'l';
        public static final String DEBUG_OPT_LONG_NAME = "debug";
        public static final String DTD_VALIDATION_OPT_LONG_NAME = "validate_dtd";
        public static final String CONTINUE_ON_ERROR_LONG_NAME = "continue_on_error";
        public static final String CONTINUOUS_OPT_LONG_NAME = "continuous";
        public static final String USE_XPATH_QUERY_NAME = "use_xpath_query";
        public static final String HELP_OPT_LONG_NAME = "help";
        public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
        private final String _usage;
        protected Options _cliOptions;
        protected CommandLine _cmd;
        HelpFormatter _helpFormatter;
        protected Level _defaultLogLevel = Level.INFO;
        private String _trailDirName;
        private String _trailFilePrefix;
        private boolean _continuous = false;
        private boolean _enableDtdValidation = false;
        private boolean _enableRegex = true;
        private String _errorLogFile = null;

        public Cli() {
            this._usage = "java " + NAME + " [options] trail_dir trail_prefix ";
            this._cliOptions = new Options();
            this.constructCommandLineOptions();
            this._helpFormatter = new HelpFormatter();
            this._helpFormatter.setWidth(150);
        }

        private void constructCommandLineOptions() {
            OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Prints command-line options info");
            Option helpOption = OptionBuilder.create((char)'h');
            OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Log4j properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option log4jPropsOption = OptionBuilder.create((char)'l');
            OptionBuilder.withLongOpt((String)DEBUG_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Turns on debugging info");
            Option debugPropsOption = OptionBuilder.create((char)'d');
            OptionBuilder.withLongOpt((String)DTD_VALIDATION_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Turns on DTD validation");
            Option dtdValidationOption = OptionBuilder.create((char)'D');
            OptionBuilder.withLongOpt((String)USE_XPATH_QUERY_NAME);
            OptionBuilder.withDescription((String)"Uses xpath queries to locate the SCNs within a transaction");
            Option useXpathQueryOption = OptionBuilder.create((char)'x');
            OptionBuilder.withLongOpt((String)CONTINUOUS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Continuously poll for new data");
            Option continuousOption = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)CONTINUE_ON_ERROR_LONG_NAME);
            OptionBuilder.withDescription((String)"Log errors and continue");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"log_file");
            Option continueOnErrorOption = OptionBuilder.create();
            this._cliOptions.addOption(debugPropsOption);
            this._cliOptions.addOption(dtdValidationOption);
            this._cliOptions.addOption(continuousOption);
            this._cliOptions.addOption(helpOption);
            this._cliOptions.addOption(useXpathQueryOption);
            this._cliOptions.addOption(log4jPropsOption);
            this._cliOptions.addOption(continueOnErrorOption);
        }

        public void printCliHelp() {
            this._helpFormatter.printHelp(this.getUsage(), this._cliOptions);
        }

        public String getUsage() {
            return this._usage;
        }

        public boolean processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
            GnuParser cliParser = new GnuParser();
            this._cmd = null;
            try {
                this._cmd = cliParser.parse(this._cliOptions, cliArgs);
            }
            catch (ParseException pe) {
                System.err.println(NAME + ": failed to parse command-line options: " + pe.toString());
                this.printCliHelp();
                return false;
            }
            if (this._cmd.hasOption('h')) {
                this.printCliHelp();
                return false;
            }
            int numArgs = this._cmd.getArgs().length;
            if (2 != numArgs) {
                System.err.println(NAME + ": incorrect command-line arguments " + numArgs + ". Should be 2");
                this.printCliHelp();
                return false;
            }
            if (this._cmd.hasOption('d')) {
                Logger.getRootLogger().setLevel(Level.DEBUG);
            } else {
                Logger.getRootLogger().setLevel(this._defaultLogLevel);
            }
            if (this._cmd.hasOption('l')) {
                String log4jPropFile = this._cmd.getOptionValue('l');
                PropertyConfigurator.configure((String)log4jPropFile);
                LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
            } else {
                PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c{1}} %m%n");
                ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
                Logger.getRootLogger().removeAllAppenders();
                Logger.getRootLogger().addAppender((Appender)defaultAppender);
                LOG.info((Object)"Using default logging settings");
            }
            this._continuous = this._cmd.hasOption('c');
            this._enableDtdValidation = this._cmd.hasOption('D');
            if (this._cmd.hasOption(CONTINUE_ON_ERROR_LONG_NAME)) {
                this._errorLogFile = this._cmd.getOptionValue(CONTINUE_ON_ERROR_LONG_NAME);
            }
            this._enableRegex = !this._cmd.hasOption('x') && !this._cmd.hasOption(USE_XPATH_QUERY_NAME);
            this._trailDirName = this._cmd.getArgs()[0];
            this._trailFilePrefix = this._cmd.getArgs()[1];
            return true;
        }

        public String getTrailDirName() {
            return this._trailDirName;
        }

        public String getTrailFilePrefix() {
            return this._trailFilePrefix;
        }

        public boolean isContinuous() {
            return this._continuous;
        }

        public boolean isDtdValidationEnabled() {
            return this._enableDtdValidation;
        }

        public boolean getEnableRegex() {
            return this._enableRegex;
        }

        protected String getErrorLogFName() {
            return this._errorLogFile;
        }
    }
}

