/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionSuccessCallBack;
import com.linkedin.databus2.ggParser.staxparser.XmlParser;
import com.linkedin.databus2.relay.config.ReplicationBitSetterConfig;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class StaxBuilderTest {
    private static final Logger LOG = Logger.getLogger((String)StaxBuilderTest.class.getName());
    private FileInputStream _fileInputStream;
    private SchemaRegistryService _schemaRegistry;
    private HashMap<String, String> _tableToNamespace;
    private HashMap<String, Integer> _tableToSourceId;
    TransactionSuccessCallBack _transactionSuccessCallBack;
    ReplicationBitSetterStaticConfig _staticReplicationConfig;

    public StaxBuilderTest(String file, SchemaRegistryService schemaRegistry, TransactionSuccessCallBack transactionSuccessCallBack) throws FileNotFoundException, DatabusException {
        this._transactionSuccessCallBack = transactionSuccessCallBack;
        this._fileInputStream = new FileInputStream(file);
        this._schemaRegistry = schemaRegistry;
        this._tableToNamespace = new HashMap();
        this._tableToNamespace.put("MEMBER2.TEST", "com.linkedin.events.member2.test.test");
        this._tableToNamespace.put("MEMBER2.TEST2", "com.linkedin.events.member2.test.test");
        this._tableToNamespace.put("MEMBER2.TEST3", "com.linkedin.events.member2.test.test");
        this._tableToSourceId = new HashMap();
        this._tableToSourceId.put("MEMBER2.TEST", 401);
        this._tableToSourceId.put("MEMBER2.TEST2", 402);
        this._tableToSourceId.put("MEMBER2.TEST3", 403);
        ReplicationBitSetterConfig _config = new ReplicationBitSetterConfig();
        _config.setFieldName("test");
        _config.setSourceType("NONE");
        this._staticReplicationConfig = _config.build();
    }

    public void processXml() throws Exception {
        try {
            String xmlStartTag = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root>";
            String xmlEndTag = "</root>";
            List<InputStream> xmlTagsList = Arrays.asList(new ByteArrayInputStream(xmlStartTag.getBytes("ISO-8859-1")), this._fileInputStream, new ByteArrayInputStream(xmlEndTag.getBytes("ISO-8859-1")));
            Enumeration<InputStream> streams = Collections.enumeration(xmlTagsList);
            SequenceInputStream seqStream = new SequenceInputStream(streams);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(seqStream);
            XmlParser parser = new XmlParser(xmlStreamReader, this._schemaRegistry, this._tableToNamespace, this._tableToSourceId, this._transactionSuccessCallBack, true, this._staticReplicationConfig, seqStream);
            parser.start();
        }
        catch (XMLStreamException e) {
            LOG.error((Object)"Unable to parse the given xml stream", (Throwable)e);
        }
    }
}

