/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachineHelper;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class TokensState
extends AbstractStateTransitionProcessor {
    public static final String MODULE = TokensState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private long scn;
    private boolean _isReplicated;

    public TokensState() {
        super(StateProcessor.STATETYPE.STARTELEMENT, "tokens");
    }

    public long getScn() {
        return this.scn;
    }

    public void setScn(long scn) {
        this.scn = scn;
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public void setReplicated(boolean replicated) {
        this._isReplicated = replicated;
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this.setScn(-1L);
        this._isReplicated = false;
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("picking scn from token state: " + stateMachine.tokenState.getScn()));
        }
        if (ReplicationBitSetterStaticConfig.SourceType.TOKEN == stateMachine.getReplicationBitConfig().getSourceType() && !stateMachine.tokenState.isSeenReplicationField() && ReplicationBitSetterStaticConfig.MissingValueBehavior.STOP_WITH_ERROR == stateMachine.getReplicationBitConfig().getMissingValueBehavior()) {
            throw new DatabusException("The replication field was not seen in the trail files in the tokens, this field is mandatory! The scn associated is: " + stateMachine.tokenState.getScn());
        }
        this.setScn(stateMachine.tokenState.getScn());
        this._isReplicated = stateMachine.tokenState.isSeenReplicationField() ? stateMachine.tokenState.isReplicated() : StateMachineHelper.verifyReplicationStatus(stateMachine.getReplicationValuePattern(), null, stateMachine.getReplicationBitConfig().getMissingValueBehavior());
        stateMachine.tokenState.cleanUpState(stateMachine, xmlStreamReader);
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }
}

