/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachineHelper;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.XmlStreamReaderHelper;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class TokenState
extends AbstractStateTransitionProcessor {
    public static final String MODULE = TokenState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String TOKENATTRNAME = "name";
    public static final String TOKENSCN = "TK-CSN";
    public static final long ERRORSCN = -1L;
    private long scn;
    private boolean _replicatedBit;
    private boolean _seenReplicationField;

    public TokenState() {
        super(StateProcessor.STATETYPE.STARTELEMENT, "token");
    }

    public boolean isSeenReplicationField() {
        return this._seenReplicationField;
    }

    public long getScn() {
        return this.scn;
    }

    public void setScn(long scn) {
        this.scn = scn;
    }

    public boolean isReplicated() {
        return this._replicatedBit;
    }

    private boolean verifyAndSetScnField(String attributeValue, String tokenValue) {
        if (attributeValue.equals(TOKENSCN)) {
            try {
                String scn = tokenValue;
                this.scn = Long.valueOf(scn);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Event with SCN:" + scn + " processed"));
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Unable to convert the scn:" + this.scn + " to long"), (Throwable)e);
                this.scn = -1L;
            }
            return true;
        }
        return false;
    }

    private boolean verifyAndSetReplicatedFlag(StateMachine stateMachine, String attributeValue, String tokenValue) throws XMLStreamException, DatabusException {
        boolean isReplicatedDbUpdate;
        ReplicationBitSetterStaticConfig.SourceType sourceType = stateMachine.getReplicationBitConfig().getSourceType();
        if (sourceType == ReplicationBitSetterStaticConfig.SourceType.TOKEN && (isReplicatedDbUpdate = attributeValue.equalsIgnoreCase(stateMachine.getReplicationBitConfig().getFieldName()))) {
            String replicationFieldValue = tokenValue;
            this._replicatedBit = StateMachineHelper.verifyReplicationStatus(stateMachine.getReplicationValuePattern(), replicationFieldValue, stateMachine.getReplicationBitConfig().getMissingValueBehavior());
            this._seenReplicationField = true;
            return true;
        }
        return false;
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this.scn = -1L;
        this._replicatedBit = false;
        this._seenReplicationField = false;
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        HashMap<String, String> attributeMap = XmlStreamReaderHelper.getAttributeMap(xmlStreamReader);
        String tokenValue = xmlStreamReader.getElementText();
        for (Map.Entry<String, String> attributeEntrySet : attributeMap.entrySet()) {
            String attributeName = attributeEntrySet.getKey();
            String attributeValue = attributeEntrySet.getValue();
            if (!attributeName.equals(TOKENATTRNAME)) {
                LOG.info((Object)("Unknown attribute name seen: " + attributeName));
                continue;
            }
            if (this.verifyAndSetReplicatedFlag(stateMachine, attributeValue, tokenValue) || this.verifyAndSetScnField(attributeValue, tokenValue) || !LOG.isDebugEnabled()) continue;
            LOG.info((Object)("Unknown attribute value seen" + attributeValue + " seen"));
        }
        if (!xmlStreamReader.isEndElement()) {
            throw new DatabusException("The process element is expected to leave the xml stream reader at end element");
        }
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }
}

