/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class StateMachineHelper {
    public static final String MODULE = StateMachineHelper.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static boolean verifyReplicationStatus(Pattern pattern, String databaseFieldValue, ReplicationBitSetterStaticConfig.MissingValueBehavior missingValueBehavior) {
        if (databaseFieldValue == null) {
            switch (missingValueBehavior) {
                case TREAT_EVENT_REPLICATED: {
                    return true;
                }
                case STOP_WITH_ERROR: 
                case TREAT_EVENT_LOCAL: {
                    return false;
                }
            }
        }
        return pattern.matcher(databaseFieldValue).matches();
    }

    public static Schema tableToSchema(String currentTable, HashMap<String, String> tableToSourceName, SchemaRegistryService schemaRegistryService) {
        String sourceName = tableToSourceName.get(currentTable);
        Schema schema = null;
        try {
            VersionedSchema vSchema = schemaRegistryService.fetchLatestVersionedSchemaBySourceName(sourceName);
            if (vSchema != null) {
                schema = vSchema.getSchema();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to fetch the schema for the table: " + currentTable + " with source name: " + sourceName + " because of the following error : " + e), (Throwable)e);
            return null;
        }
        if (schema == null) {
            return null;
        }
        return schema;
    }
}

