/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.ggParser.XmlStateMachine.ColumnState;
import com.linkedin.databus2.ggParser.XmlStateMachine.ColumnsState;
import com.linkedin.databus2.ggParser.XmlStateMachine.DbUpdateState;
import com.linkedin.databus2.ggParser.XmlStateMachine.RootState;
import com.linkedin.databus2.ggParser.XmlStateMachine.ShutdownState;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.TokenState;
import com.linkedin.databus2.ggParser.XmlStateMachine.TokensState;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionState;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionSuccessCallBack;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class StateMachine {
    public static final String MODULE = StateMachine.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final Pattern _replicationValuePattern;
    private StateProcessor _processState;
    private GenericRecord _genericRecord;
    private HashMap<String, String> _tableToSourceNameMap;
    private HashMap<String, Integer> _tableToSourceId;
    private SchemaRegistryService _schemaRegistryService;
    private ReplicationBitSetterStaticConfig _replicationBitConfig;
    TransactionState transactionState;
    DbUpdateState dbUpdateState;
    ColumnsState columnsState;
    ColumnState columnState;
    RootState rootState;
    TokensState tokensState;
    TokenState tokenState;
    ShutdownState shutdownState;

    public ReplicationBitSetterStaticConfig getReplicationBitConfig() {
        return this._replicationBitConfig;
    }

    public Pattern getReplicationValuePattern() {
        return this._replicationValuePattern;
    }

    public HashMap<String, Integer> getTableToSourceId() {
        return this._tableToSourceId;
    }

    public void setTableToSourceId(HashMap<String, Integer> tableToSourceId) {
        this._tableToSourceId = tableToSourceId;
    }

    public HashMap<String, String> getTableToSourceNameMap() {
        return this._tableToSourceNameMap;
    }

    public SchemaRegistryService getSchemaRegistryService() {
        return this._schemaRegistryService;
    }

    public void setGenericRecord(GenericRecord genericRecord) {
        this._genericRecord = genericRecord;
    }

    public GenericRecord getGenericRecord() {
        return this._genericRecord;
    }

    public StateProcessor getProcessState() {
        return this._processState;
    }

    public void setProcessState(StateProcessor processState) {
        this._processState = processState;
    }

    public StateMachine(SchemaRegistryService schemaRegistryService, HashMap<String, String> tableMap, HashMap<String, Integer> tableToSourceId, TransactionSuccessCallBack transactionSuccessCallBack, boolean errorOnMissingFields, ReplicationBitSetterStaticConfig replicationBitConfig) {
        if (!errorOnMissingFields) {
            LOG.warn((Object)"The parser will NOT terminate if fields are missing in the trail file");
        }
        this.transactionState = new TransactionState(transactionSuccessCallBack);
        this.dbUpdateState = new DbUpdateState();
        this.columnsState = new ColumnsState(errorOnMissingFields);
        this.columnState = new ColumnState();
        this.rootState = new RootState();
        this.tokensState = new TokensState();
        this.shutdownState = new ShutdownState();
        this.tokenState = new TokenState();
        this._processState = this.rootState;
        this._schemaRegistryService = schemaRegistryService;
        this._tableToSourceNameMap = tableMap;
        this._tableToSourceId = tableToSourceId;
        this._replicationBitConfig = replicationBitConfig;
        this._replicationValuePattern = this._replicationBitConfig != null && this._replicationBitConfig.getRemoteUpdateValueRegex() != null ? Pattern.compile(this._replicationBitConfig.getRemoteUpdateValueRegex()) : null;
    }

    public void processElement(XMLStreamReader xmlStreamReader) throws Exception {
        try {
            this._processState.processElement(this, xmlStreamReader);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception. Last seen txn timestamp was : (" + this.transactionState.getLastSeenTxnTimestampStr() + ")"), (Throwable)e);
            throw e;
        }
    }
}

