/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public class PrimaryKey {
    private final String _pKey;
    private final List<String> _pKeyList = new ArrayList<String>(3);

    public PrimaryKey(String pKey) throws DatabusException {
        if (pKey == null) {
            throw new DatabusException("PrimaryKey cannot be null");
        }
        this._pKey = pKey;
        String[] pKeyList = this._pKey.split(",");
        assert (pKeyList.length >= 1);
        for (String s : pKeyList) {
            this._pKeyList.add(s.trim());
        }
    }

    public String getPKey() {
        return this._pKey;
    }

    public List<String> getPKeyList() {
        return this._pKeyList;
    }

    public boolean isCompositeKey() {
        return this._pKeyList.size() != 1;
    }

    public int getNumKeys() {
        return this._pKeyList.size();
    }

    protected boolean isPartOfPrimaryKey(Schema.Field field) {
        String trimmedFName = field.name().trim();
        return this._pKeyList.contains(trimmedFName);
    }

    public static boolean isPrimaryKey(String pkFieldName, Schema.Field field) {
        boolean isPrimaryKey = false;
        try {
            PrimaryKey pk = new PrimaryKey(pkFieldName);
            isPrimaryKey = pk.isPartOfPrimaryKey(field);
        }
        catch (DatabusException de) {
            isPrimaryKey = false;
        }
        return isPrimaryKey;
    }
}

