/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.XmlStreamReaderHelper;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class ColumnState
extends AbstractStateTransitionProcessor {
    public static final String MODULE = ColumnState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String FIELDNAMEATTR = "name";
    public static final String KEYNAMEATTR = "key";
    public static final String STATUSATTR = "status";
    private HashMap<String, EventField> eventFields;

    public ColumnState() {
        super(StateProcessor.STATETYPE.STARTELEMENT, "column");
    }

    public HashMap<String, EventField> getEventFields() {
        return this.eventFields;
    }

    public void setEventFields(HashMap<String, EventField> eventFields) {
        this.eventFields = eventFields;
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws Exception {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        String currentField = null;
        boolean isKey = false;
        boolean isNull = false;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equals(FIELDNAMEATTR)) {
                currentField = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equals(KEYNAMEATTR)) {
                try {
                    isKey = Boolean.valueOf(xmlStreamReader.getAttributeValue(i));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Key field located: " + currentField));
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)"Unable to interpret key field: ", (Throwable)e);
                }
                continue;
            }
            if (!xmlStreamReader.getAttributeName(i).getLocalPart().equals(STATUSATTR) || !xmlStreamReader.getAttributeValue(i).equals("null")) continue;
            isNull = true;
        }
        if (currentField == null || currentField.length() == 0) {
            LOG.error((Object)("Unable to parse current column field type: " + currentField));
            XmlStreamReaderHelper.checkAndMoveToNextTagSet(xmlStreamReader);
            this.setNextStateProcessor(stateMachine, xmlStreamReader);
            return;
        }
        String currentFieldValue = xmlStreamReader.getElementText();
        this.getEventFields().put(currentField, new EventField(isKey, currentFieldValue, isNull));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processed the field " + currentField + " with value " + currentFieldValue + " and isNull: " + isNull));
        }
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this.setEventFields(null);
    }

    public static class EventField {
        boolean isKey;
        String val;
        boolean isNull;

        public EventField(boolean key, String val, boolean isNull) {
            this.isKey = key;
            this.val = val;
            this.isNull = isNull;
        }

        public String getVal() {
            return this.val;
        }

        public boolean isKey() {
            return this.isKey;
        }

        public boolean isNull() {
            return this.isNull;
        }
    }
}

