/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.ConcurrentAppendableCompositeFileInputStream;
import com.linkedin.databus.core.ScnTxnPos;
import com.linkedin.databus.core.TrailFileNotifier;
import com.linkedin.databus2.core.DatabusException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TrailFilePositionSetter {
    public Logger _log;
    public static final long USE_LATEST_SCN = -1L;
    public static final long USE_EARLIEST_SCN = -2L;
    private final File _dir;
    private final String _filePrefix;
    private final FileFilter _filter;
    private String _phySourceName;
    public static final String NEW_LINE_PATTERN_STR = "\r?\n|\r";
    public static final String DOUBLE_CHAR_NEWLINE = "\r\n";
    public static final int NO_NEWLINE_LEN = -1;

    public TrailFilePositionSetter(String dir, String filePrefix) throws IOException {
        String MODULE = TrailFilePositionSetter.class.getName();
        this._log = Logger.getLogger((String)MODULE);
        TrailFilePositionSetter.validateDir(dir);
        this._dir = new File(dir);
        this._filePrefix = filePrefix;
        this._filter = new FileFilter(this._dir, this._filePrefix);
        this._phySourceName = "";
    }

    public TrailFilePositionSetter(String dir, String filePrefix, String phySourceName) throws IOException {
        this(dir, filePrefix);
        this._phySourceName = phySourceName != null ? phySourceName : "";
        String MODULE = TrailFilePositionSetter.class.getName();
        this._log = Logger.getLogger((String)(MODULE + ":" + this._phySourceName));
    }

    private static void validateDir(String dir) throws IOException {
        File d = new File(dir);
        if (!d.isDirectory()) {
            throw new IOException("Path (" + dir + ") does not exist or is not a directory !!");
        }
    }

    public synchronized FilePositionResult locateFilePosition(long scn, TransactionSCNFinderCallback callback) throws IOException {
        TrailFileNotifier notifier = new TrailFileNotifier(this._dir, this._filter, null, 0L, null);
        List<File> orderedTrailFiles = notifier.getCandidateTrailFiles();
        this._log.info((Object)("Initial set of Trail Files :" + orderedTrailFiles));
        if (null == orderedTrailFiles || orderedTrailFiles.isEmpty()) {
            return FilePositionResult.createNoTxnsFoundResult();
        }
        FilePositionResult res = null;
        if (scn == -2L) {
            res = this.getFilePosition(scn, callback);
        } else {
            for (int i = orderedTrailFiles.size() - 1; i >= 0; --i) {
                ScnTxnPos scnTxnPos;
                callback.reset();
                File startFile = orderedTrailFiles.get(i);
                this._log.info((Object)("Locating the SCN (" + scn + ") starting from the trail file :" + startFile));
                res = this.getFilePosition(scn, callback, startFile.getName());
                this._log.info((Object)("Result of the location operation for SCN (" + scn + ") starting from trail file (" + startFile + ") is : " + res));
                if ((res.getStatus() == FilePositionResult.Status.EXACT_SCN_NOT_FOUND || res.getStatus() == FilePositionResult.Status.FOUND) && res.getTxnPos().getTxnRank() > 0L) break;
                if (0 != i || res == null || (scnTxnPos = res.getTxnPos()) == null || scnTxnPos.getTxnRank() > 0L) continue;
                return FilePositionResult.createErrorResult(new DatabusException("A transaction with scn less than requested SCN was not found. Without this txn, we cannot identify if all transactions for requested SCN have been located. Requested SinceSCN is :" + scn));
            }
        }
        return res;
    }

    protected synchronized FilePositionResult getFilePosition(long scn, TransactionSCNFinderCallback callback) throws IOException {
        return this.getFilePosition(scn, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized FilePositionResult getFilePosition(long scn, TransactionSCNFinderCallback callback, String startFile) throws IOException {
        ConcurrentAppendableCompositeFileInputStream stream = null;
        FilePositionResult result = null;
        try {
            stream = new ConcurrentAppendableCompositeFileInputStream(this._dir.getAbsolutePath(), startFile, -1L, this._filter, true);
            result = this.findTxnScn(stream, scn, callback);
            this._log.info((Object)("File Position result for scn (" + scn + ") is :" + result));
            this._log.info((Object)("Input Stream Rate Monitor - " + stream.getRateMonitor()));
            this._log.info((Object)("Callback RM - " + callback.getPerfStats()));
        }
        catch (IOException io) {
            this._log.error((Object)"Unable to fetch the file position and offsets");
            result = FilePositionResult.createErrorResult(io);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return result;
    }

    private FilePositionResult findTxnScn(ConcurrentAppendableCompositeFileInputStream stream, long expScn, TransactionSCNFinderCallback callback) throws IOException {
        FilePositionResult result = null;
        ScnTxnPos pos = null;
        callback.begin(expScn);
        byte[] bArr = new byte[4096];
        File prevFile = null;
        File currFile = null;
        long currPosition = -1L;
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Integer> lineEndPos = new ArrayList<Integer>();
        String prevLine = null;
        boolean done = false;
        while (!done) {
            prevFile = currFile;
            int numBytes = stream.read(bArr);
            if (numBytes <= 0) break;
            currFile = stream.getCurrentFile();
            currPosition = stream.getCurrentPosition();
            boolean spanFile = false;
            int endOffset = 0;
            if (currFile != null && prevFile != null && !currFile.equals(prevFile)) {
                spanFile = true;
                endOffset = (int)((long)numBytes - currPosition);
            }
            prevLine = TrailFilePositionSetter.splitBytesByNewLines(bArr, numBytes, spanFile, endOffset, prevLine, lines, lineEndPos);
            if (prevFile == null) {
                callback.beginFileProcessing(currFile.getName());
            }
            int currOffset = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String l = (String)lines.get(i);
                int newLineLen = (Integer)lineEndPos.get(i) - currOffset - l.length();
                try {
                    done = callback.processLine(l, newLineLen);
                }
                catch (DatabusException e) {
                    this._log.error((Object)("Got Exception when processing line (" + l + ")."), (Throwable)e);
                    result = FilePositionResult.createErrorResult(e);
                    return result;
                }
                if (done) break;
                if ((Integer)lineEndPos.get(i) == -1) {
                    callback.endFileProcessing(prevFile.getName());
                    callback.beginFileProcessing(currFile.getName());
                }
                currOffset = (Integer)lineEndPos.get(i) < 0 ? currOffset + l.length() : (Integer)lineEndPos.get(i);
            }
            lines.clear();
            lineEndPos.clear();
        }
        if (!done && prevLine != null) {
            try {
                callback.processLine(prevLine, -1);
            }
            catch (DatabusException e) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Got Exception when processing line (" + prevLine + ")."), (Throwable)e);
                }
                result = FilePositionResult.createErrorResult(e);
                return result;
            }
        }
        pos = callback.getTxnPos();
        result = callback.getNumTxnsSeen() <= 0L ? FilePositionResult.createNoTxnsFoundResult() : (expScn == -1L ? FilePositionResult.createFoundResult(pos) : (expScn == -2L ? FilePositionResult.createFoundResult(pos) : (pos.getMaxScn() == expScn ? FilePositionResult.createFoundResult(pos) : FilePositionResult.createExactScnNotFoundResult(pos))));
        return result;
    }

    protected static String splitBytesByNewLines(byte[] buf, int numBytes, boolean spanFile, int endOffset, String prevLine, List<String> lines, List<Integer> lineEndPos) {
        String[] strArr;
        String s;
        String string = s = prevLine != null ? prevLine + new String(buf, 0, numBytes) : new String(buf, 0, numBytes);
        if (s.isEmpty()) {
            return null;
        }
        if (prevLine != null) {
            endOffset += prevLine.length();
        }
        if ((strArr = s.split(NEW_LINE_PATTERN_STR)).length == 0) {
            strArr = new String[]{""};
        }
        int pos = 0;
        for (int i = 0; i < strArr.length - 1; ++i) {
            String l = strArr[i];
            if (spanFile && pos <= endOffset && pos + l.length() > endOffset) {
                int pivot = endOffset - pos;
                lines.add(l.substring(0, pivot));
                pos += pivot;
                l = l.substring(pivot);
                lineEndPos.add(-1);
                spanFile = false;
            }
            lines.add(l);
            int newLineLen = 0;
            newLineLen = s.startsWith(DOUBLE_CHAR_NEWLINE, pos += l.length()) ? 2 : 1;
            lineEndPos.add(pos += newLineLen);
        }
        char c = s.charAt(s.length() - 1);
        String lastLine = null;
        String l = strArr[strArr.length - 1];
        if (spanFile && pos <= endOffset && pos + l.length() > endOffset) {
            int pivot = endOffset - pos;
            lines.add(l.substring(0, pivot));
            pos += pivot;
            l = l.substring(pivot);
            lineEndPos.add(-1);
        }
        if (c == '\r') {
            lastLine = l + '\r';
        } else if (c != '\n') {
            lastLine = l;
        } else {
            lines.add(l);
            pos = s.startsWith(DOUBLE_CHAR_NEWLINE, pos += l.length()) ? (pos += 2) : ++pos;
            lineEndPos.add(pos);
        }
        return lastLine;
    }

    public static interface TransactionSCNFinderCallback {
        public void begin(long var1);

        public void beginFileProcessing(String var1);

        public boolean processLine(String var1, int var2) throws DatabusException;

        public void endFileProcessing(String var1);

        public ScnTxnPos getTxnPos();

        public long getNumTxnsSeen();

        public long getCurrentFileOffset();

        public void reset();

        public String getPerfStats();
    }

    public static class FileFilter
    implements TrailFileNotifier.TrailFileManager {
        private final String _prefix;
        private final Pattern _trailFileNamePattern;

        public FileFilter(File dir, String prefix) {
            this._prefix = prefix;
            String trailFileNameRegex = prefix + "[\\d]+";
            this._trailFileNamePattern = Pattern.compile(trailFileNameRegex);
        }

        @Override
        public int compareFileName(File file1, File file2) {
            String f1 = file1.getName().substring(this._prefix.length());
            String f2 = file2.getName().substring(this._prefix.length());
            Long num1 = Long.parseLong(f1);
            Long num2 = Long.parseLong(f2);
            return num1.compareTo(num2);
        }

        @Override
        public boolean isTrailFile(File file) {
            return null != file && this._trailFileNamePattern.matcher(file.getName()).matches();
        }

        @Override
        public boolean isNextFileInSequence(File file1, File file2) {
            String f1 = file1.getName().substring(this._prefix.length());
            String f2 = file2.getName().substring(this._prefix.length());
            long num1 = Long.parseLong(f1);
            long num2 = Long.parseLong(f2);
            return num2 - num1 == 1L;
        }
    }

    public static class FilePositionResult {
        private final Status _status;
        private final ScnTxnPos _txnPos;
        private final Throwable _error;

        public static FilePositionResult createFoundResult(ScnTxnPos scnTxnPos) {
            return new FilePositionResult(Status.FOUND, scnTxnPos);
        }

        public static FilePositionResult createExactScnNotFoundResult(ScnTxnPos pos) {
            return new FilePositionResult(Status.EXACT_SCN_NOT_FOUND, pos);
        }

        public static FilePositionResult createNoTxnsFoundResult() {
            return new FilePositionResult(Status.NO_TXNS_FOUND, null);
        }

        public static FilePositionResult createErrorResult(Throwable ex) {
            return new FilePositionResult(ex);
        }

        private FilePositionResult(Status status, ScnTxnPos txnPos) {
            this._status = status;
            this._txnPos = txnPos;
            this._error = null;
        }

        private FilePositionResult(Throwable err) {
            this._status = Status.ERROR;
            this._txnPos = null;
            this._error = err;
        }

        public Throwable getError() {
            return this._error;
        }

        public Status getStatus() {
            return this._status;
        }

        public ScnTxnPos getTxnPos() {
            return this._txnPos;
        }

        public String toString() {
            return "FilePositionResult [_status=" + (Object)((Object)this._status) + ", _txnPos=" + this._txnPos + "]";
        }

        public static enum Status {
            FOUND,
            EXACT_SCN_NOT_FOUND,
            NO_TXNS_FOUND,
            ERROR;

        }
    }
}

