/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusThreadBase;
import com.linkedin.databus2.core.DatabusException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class TrailFileNotifier
extends DatabusThreadBase {
    public static final String MODULE = TrailFileNotifier.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final File _dir;
    private final long _pollIntervalMs;
    private final TrailFileManager _fileFilter;
    private final TrailFileListener _trailFileListener;
    private final File _initialFileToBeginProcessing;
    private File _lastSeenFile;
    private boolean _shutdownOnError = false;

    public TrailFileNotifier(File dir, TrailFileManager fileFilter, File startFile, long pollIntervalMs, TrailFileListener trailFileListener) {
        super(MODULE);
        this._dir = dir;
        this._initialFileToBeginProcessing = startFile;
        this._pollIntervalMs = pollIntervalMs;
        this._trailFileListener = trailFileListener;
        this._fileFilter = fileFilter;
    }

    public boolean runOnce() {
        LOG.debug((Object)"TrailFileNotifier running one cycle !!");
        boolean success = this.fetchOneTime();
        if (!success) {
            this._shutdownOnError = true;
            return false;
        }
        try {
            Thread.sleep(this._pollIntervalMs);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)("Got interrupted while sleeping for :" + this._pollIntervalMs + " ms"));
        }
        return true;
    }

    public void beforeRun() {
    }

    public void afterRun() {
    }

    public synchronized boolean fetchOneTime() {
        List<File> candidateTrailFiles = this.getCandidateTrailFiles();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Final List of Files in Directory :" + candidateTrailFiles));
        }
        try {
            for (File t : candidateTrailFiles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding trail file :" + t));
                }
                this._trailFileListener.onNewTrailFile(t);
                this._lastSeenFile = t;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Got exception while enqueuing trail file", (Throwable)ex);
            this._trailFileListener.onError(ex);
            return false;
        }
        return true;
    }

    public synchronized List<File> getCandidateTrailFiles() {
        Object[] filesInDirArray = this._dir.listFiles();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files in Directory :" + Arrays.toString(filesInDirArray)));
        }
        ArrayList<File> candidateTrailFiles = new ArrayList<File>();
        if (null != filesInDirArray) {
            for (Object t : filesInDirArray) {
                if (null == t || !this._fileFilter.isTrailFile((File)t) || null != this._initialFileToBeginProcessing && this._fileFilter.compareFileName((File)t, this._initialFileToBeginProcessing) < 0 || null != this._lastSeenFile && this._fileFilter.compareFileName((File)t, this._lastSeenFile) <= 0) continue;
                candidateTrailFiles.add((File)t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Candidate Files in Directory :" + candidateTrailFiles));
        }
        Collections.sort(candidateTrailFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return TrailFileNotifier.this._fileFilter.compareFileName(o1, o2);
            }
        });
        return candidateTrailFiles;
    }

    public boolean isShutdownOnError() {
        return this._shutdownOnError;
    }

    public static interface TrailFileListener {
        public void onNewTrailFile(File var1) throws DatabusException;

        public void onError(Throwable var1);
    }

    public static interface TrailFileManager {
        public int compareFileName(File var1, File var2);

        public boolean isTrailFile(File var1);

        public boolean isNextFileInSequence(File var1, File var2);
    }
}

