/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class SourcesRequestProcessor
implements RequestProcessor {
    public static final String MODULE = SourcesRequestProcessor.class.getName();
    public static Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "sources";
    public static final String VERSION_PARAM_NAME = "v";
    private final ExecutorService _executorService;
    private final HttpRelay _relay;

    public SourcesRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._executorService = executorService;
        this._relay = relay;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        int protoVersion = request.getOptionalIntParam(VERSION_PARAM_NAME, 1);
        ObjectMapper mapper = new ObjectMapper();
        StringWriter out = new StringWriter(10240);
        Collection sources = this._relay.getSourcesIdNameRegistry().getAllSources();
        if (1 == protoVersion) {
            ArrayList<IdNamePair> sourcePairs = new ArrayList<IdNamePair>(sources.size());
            for (LogicalSource source : sources) {
                sourcePairs.add(new IdNamePair(Long.valueOf(source.getId().longValue()), source.getName()));
            }
            mapper.writeValue((Writer)out, sourcePairs);
        } else if (2 == protoVersion) {
            mapper.writeValue((Writer)out, (Object)sources);
        } else {
            throw new InvalidRequestParamValueException(COMMAND_NAME, VERSION_PARAM_NAME, Integer.toString(protoVersion));
        }
        byte[] resultBytes = out.toString().getBytes(Charset.defaultCharset());
        request.getResponseContent().write(ByteBuffer.wrap(resultBytes));
        HttpStatisticsCollector relayStatsCollector = this._relay.getHttpStatisticsCollector();
        if (null != relayStatsCollector) {
            HttpStatisticsCollector connStatsCollector = (HttpStatisticsCollector)request.getParams().get(relayStatsCollector.getName());
            if (null != connStatsCollector) {
                connStatsCollector.registerSourcesCall();
            } else {
                relayStatsCollector.registerSourcesCall();
            }
        }
        return request;
    }
}

