/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DbusEventStatsCollectorsPartitioner;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.ContainerStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class RelayContainerStatsRequestProcessor
extends ContainerStatsRequestProcessor {
    private final HttpRelay _relay;

    public RelayContainerStatsRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        super(executorService, (ServerContainer)relay);
        this._relay = relay;
    }

    public boolean doProcess(String category, DatabusRequest request) throws IOException, RequestProcessingException {
        if (category.startsWith("inbound/events/psource/")) {
            this.processStats((StatsCollectors<DbusEventsStatisticsCollector>)this._relay.getInBoundStatsCollectors(), this._relay.getDbInboundStatsCollectors(), "inbound/events/psource/", request);
            return true;
        }
        if (category.startsWith("outbound/events/psource/")) {
            this.processStats((StatsCollectors<DbusEventsStatisticsCollector>)this._relay.getOutBoundStatsCollectors(), this._relay.getDbOutboundStatsCollectors(), "outbound/events/psource/", request);
            return true;
        }
        return super.doProcess(category, request);
    }

    private void processStats(StatsCollectors<DbusEventsStatisticsCollector> globalStatsCollector, DbusEventStatsCollectorsPartitioner resourceGroupStatsCollector, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        StatsCollectors c;
        String reqPathStr = request.getParams().getProperty("reqpath");
        String reqPathSuffix = reqPathStr.substring(prefix.length());
        reqPathSuffix = reqPathSuffix.replace('/', ':');
        DbusEventsTotalStats sourceStats = null;
        if (reqPathSuffix.contains(":")) {
            if (null != globalStatsCollector) {
                DbusEventsStatisticsCollector s = (DbusEventsStatisticsCollector)globalStatsCollector.getStatsCollector(reqPathSuffix);
                sourceStats = s == null ? null : s.getTotalStats();
            }
        } else if (null != resourceGroupStatsCollector && null != (c = resourceGroupStatsCollector.getDBStatsCollector(reqPathSuffix))) {
            sourceStats = ((DbusEventsStatisticsCollector)c.getStatsCollector()).getTotalStats();
        }
        if (null == sourceStats) {
            LOG.warn((Object)("No Stats for this source=" + request.getName() + ", prefix=" + prefix + ", DB/Physical Partition String=" + reqPathSuffix));
            sourceStats = new DbusEventsTotalStats(0, reqPathSuffix, false, false, null);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)sourceStats, request);
        }
    }
}

