/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.DbusEventSerializable;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class LoadDataEventsRequestProcessor
implements RequestProcessor {
    public static final Logger LOG = Logger.getLogger((String)LoadDataEventsRequestProcessor.class.getName());
    public static final String COMMAND_NAME = "loadDataEvents";
    public static final String FILE_PATH_PARAM = "file";
    public static final String START_WINDOW_PARAM = "startWindow";
    public static final String PHYSICAL_PARTITION_ID_PARAM = "physicalPartionId";
    private final ExecutorService _executorService;
    private final HttpRelay _relay;
    private final DbusEventBufferMult _eventBuffer;

    public LoadDataEventsRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._executorService = executorService;
        this._relay = relay;
        this._eventBuffer = this._relay.getEventBuffer();
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String fileStr = request.getRequiredStringParam(FILE_PATH_PARAM);
        String startWinStr = request.getParams().getProperty(START_WINDOW_PARAM, "false");
        String physicalParitionParameter = request.getParams().getProperty(PHYSICAL_PARTITION_ID_PARAM);
        LOG.info((Object)("physicalPartionId=" + physicalParitionParameter));
        PhysicalPartition pPartition = PhysicalSourceStaticConfig.getDefaultPhysicalPartition();
        if (physicalParitionParameter != null) {
            pPartition = PhysicalPartition.parsePhysicalPartitionString((String)physicalParitionParameter, (String)"_");
        }
        boolean startWin = Boolean.valueOf(startWinStr);
        BufferedReader in = new BufferedReader(new FileReader(fileStr));
        try {
            DbusEventBuffer buf = (DbusEventBuffer)this._eventBuffer.getDbusEventBufferAppendable(pPartition);
            if (buf == null) {
                throw new RequestProcessingException("cannot find buffer for ph. partion " + pPartition);
            }
            if (buf.getMinScn() < 0L && buf.getPrevScn() < 0L) {
                buf.start(0L);
            }
            try {
                DbusEventsStatisticsCollector statsCollector = (DbusEventsStatisticsCollector)this._relay.getInBoundStatsCollectors().getStatsCollector(pPartition.toSimpleString());
                int eventsAppended = 0;
                eventsAppended = DbusEventSerializable.appendToEventBuffer((BufferedReader)in, (DbusEventBufferAppendable)buf, (DbusEventsStatisticsCollector)statsCollector, (boolean)startWin);
                if (eventsAppended <= 0) {
                    throw new RequestProcessingException("event loading failed");
                }
                StringBuilder res = new StringBuilder(20);
                res.append("{\"eventsAppended\":");
                res.append(eventsAppended);
                res.append("}");
                request.getResponseContent().write(ByteBuffer.wrap(res.toString().getBytes(Charset.defaultCharset())));
            }
            catch (InvalidEventException iee) {
                throw new RequestProcessingException((Throwable)iee);
            }
            catch (RuntimeException re) {
                LOG.error((Object)("runttime excception: " + re.getMessage()), (Throwable)re);
                throw re;
            }
        }
        finally {
            in.close();
        }
        return request;
    }
}

