/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.producers.EventProducer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ControlSourceEventsRequestProcessor
implements RequestProcessor {
    private final ExecutorService _executorService;
    private List<EventProducer> _eventProducers;
    public static final String COMMAND_NAME = "controlSources";
    public static final String PARAM_SOURCE_NAMES = "sources";
    public static final String PARAM_SCN = "scn";

    public ControlSourceEventsRequestProcessor(ExecutorService executorService, HttpRelay relay, EventProducer eventProducer) {
        this._executorService = executorService;
        this._eventProducers = new ArrayList<EventProducer>();
        this._eventProducers.add(eventProducer);
    }

    public ControlSourceEventsRequestProcessor(ExecutorService executorService, HttpRelay relay, List<EventProducer> eventProducers) {
        this._executorService = executorService;
        this._eventProducers = new ArrayList<EventProducer>();
        this._eventProducers.addAll(eventProducers);
    }

    public void addEventProducers(List<EventProducer> eventProducers) {
        this._eventProducers.addAll(eventProducers);
    }

    public void removeEventProducers(List<EventProducer> eventProducers) {
        this._eventProducers.removeAll(eventProducers);
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        Actions action;
        try {
            String strAction = request.getParams().getProperty("reqpath", "");
            action = Actions.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "request path", request.getParams().getProperty("reqpath", ""));
        }
        switch (action) {
            case STATUS: {
                this.doStatus(request);
                break;
            }
            case PAUSE: {
                this.doPause(request);
                break;
            }
            case SHUTDOWN: {
                this.doShutdown(request);
                break;
            }
            case START: {
                this.doStart(request);
                break;
            }
            case UNPAUSE: {
                this.doUnpause(request);
            }
        }
        return null;
    }

    private void doStatus(DatabusRequest request) throws IOException {
        Set<String> sources = this.getSourcesParam(request);
        for (EventProducer producer : this._eventProducers) {
            if (sources != null && !sources.contains(producer.getName())) continue;
            String state = producer.isRunning() ? "running" : (producer.isPaused() ? "paused" : "shutdown");
            this.write(request, String.format("{\"name\" : \"%s\", \"status\" : \"%s\", \"SCN\" : %d}", producer.getName(), state, producer.getSCN()));
        }
    }

    private void doPause(DatabusRequest request) throws IOException {
        Set<String> sources = this.getSourcesParam(request);
        for (EventProducer producer : this._eventProducers) {
            if (sources != null && !sources.contains(producer.getName())) continue;
            producer.pause();
        }
        this.doStatus(request);
    }

    private void doUnpause(DatabusRequest request) throws IOException {
        Set<String> sources = this.getSourcesParam(request);
        for (EventProducer producer : this._eventProducers) {
            if (sources != null && !sources.contains(producer.getName())) continue;
            producer.unpause();
        }
        this.doStatus(request);
    }

    private void doShutdown(DatabusRequest request) throws IOException {
        Set<String> sources = this.getSourcesParam(request);
        for (EventProducer producer : this._eventProducers) {
            if (sources != null && !sources.contains(producer.getName())) continue;
            producer.shutdown();
        }
        this.doStatus(request);
    }

    private void doStart(DatabusRequest request) throws IOException, RequestProcessingException {
        Set<String> sources = this.getSourcesParam(request);
        if (sources == null || sources.size() != 1) {
            throw new RequestProcessingException("start requires exactly one source be specified");
        }
        long scn = request.getOptionalLongParam(PARAM_SCN, -1L);
        for (EventProducer producer : this._eventProducers) {
            if (!sources.contains(producer.getName())) continue;
            producer.start(scn);
            this.write(request, String.format("{\"name\" : \"%s\", \"status\" : \"%s\", \"SCN\" : %d}", producer.getName(), "running", producer.getSCN()));
        }
    }

    private Set<String> getSourcesParam(DatabusRequest request) {
        String s = request.getParams().getProperty(PARAM_SOURCE_NAMES);
        if (s == null || s.length() == 0) {
            return null;
        }
        String[] sources = s.split(",");
        HashSet<String> sourceSet = new HashSet<String>(sources.length);
        sourceSet.addAll(Arrays.asList(sources));
        return sourceSet;
    }

    private void write(DatabusRequest request, String str) throws IOException {
        request.getResponseContent().write(ByteBuffer.wrap(str.getBytes(Charset.defaultCharset())));
    }

    private static enum Actions {
        STATUS,
        START,
        PAUSE,
        UNPAUSE,
        SHUTDOWN;

    }
}

