/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.core.BufferInfoResponse;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.BufferNotFoundException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.AbstractRequestProcesser;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class BufferInfoRequestProcessor
extends AbstractRequestProcesser {
    public static final String MODULE = BufferInfoRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "bufferInfo";
    private static final String INBOUND_VIEW = "inbound/";
    private final ExecutorService _executorService;
    private final DbusEventBufferMult _eventBufferMult;

    public BufferInfoRequestProcessor(ExecutorService executorService, DbusEventBufferMult eventBuffer) {
        this._executorService = executorService;
        this._eventBufferMult = eventBuffer;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException, DatabusException {
        String category = request.getParams().getProperty("reqpath");
        if (null == category) {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "category", "null");
        }
        if (!category.startsWith(INBOUND_VIEW)) {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "category", category);
        }
        String sourceIdStr = category.substring(INBOUND_VIEW.length());
        sourceIdStr = sourceIdStr.replace('/', ':');
        PhysicalPartition pPartition = PhysicalPartition.parsePhysicalPartitionString((String)sourceIdStr, (String)":");
        this.processInboundRequest(request, pPartition);
        return request;
    }

    private void processInboundRequest(DatabusRequest request, PhysicalPartition pPart) throws IOException, DatabusException {
        DbusEventBuffer evb = this._eventBufferMult.getOneBuffer(pPart);
        if (null == evb) {
            LOG.error((Object)("BufferInfoRequest : Buffer not available for physical partition :" + pPart));
            throw new BufferNotFoundException("Buffer not available for partition :" + pPart);
        }
        BufferInfoResponse response = new BufferInfoResponse();
        response.setMinScn(evb.getMinScn());
        response.setMaxScn(evb.lastWrittenScn());
        response.setTimestampFirstEvent(evb.getTimestampOfFirstEvent());
        response.setTimestampLatestEvent(evb.getTimestampOfLatestDataEvent());
        this.writeJsonObjectToResponse(response, request);
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }
}

