/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.netty;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class RelayStatisticsCollectingHandler
extends SimpleChannelHandler {
    public static final String MODULE = RelayStatisticsCollectingHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final HttpRelay _relay;
    private DbusEventsStatisticsCollector _outEventStatsCollector;
    private DbusEventsStatisticsCollector _connOutEventStatsCollector;
    private HttpStatisticsCollector _outHttpStatsCollector;
    private HttpStatisticsCollector _connOutHttpStatsCollector;
    private DatabusRequest _latestDbusRequest = null;

    public RelayStatisticsCollectingHandler(HttpRelay relay) {
        this._relay = relay;
        this._outEventStatsCollector = this._relay.getOutboundEventStatisticsCollector();
        this._outHttpStatsCollector = this._relay.getHttpStatisticsCollector();
        this._connOutEventStatsCollector = null;
    }

    private boolean shouldMerge(MessageEvent me) {
        return me.getMessage() instanceof HttpChunkTrailer || me.getMessage() instanceof HttpResponse;
    }

    private void mergePerConnStats() {
        if (null != this._connOutEventStatsCollector) {
            this._outEventStatsCollector.merge(this._connOutEventStatsCollector);
            this._connOutEventStatsCollector.reset();
        }
        if (null != this._connOutHttpStatsCollector) {
            this._outHttpStatsCollector.merge(this._connOutHttpStatsCollector);
            this._connOutHttpStatsCollector.reset();
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._outEventStatsCollector || null != this._outHttpStatsCollector) {
            InetSocketAddress inetAddress;
            Object value = e.getValue();
            String client = null;
            client = value instanceof InetSocketAddress ? ((inetAddress = (InetSocketAddress)value).getAddress().isLoopbackAddress() ? "localhost" : inetAddress.getAddress().getHostAddress()) : e.getValue().toString();
            if (null != this._outEventStatsCollector) {
                this._connOutEventStatsCollector = this._outEventStatsCollector.createForPeerConnection(client);
            }
            if (null != this._outHttpStatsCollector) {
                this._connOutHttpStatsCollector = this._outHttpStatsCollector.createForClientConnection(client);
            }
        }
        super.channelConnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (null != this._outEventStatsCollector || null != this._outHttpStatsCollector) {
            if (e.getMessage() instanceof DatabusRequest) {
                this._latestDbusRequest = (DatabusRequest)e.getMessage();
                if (null != this._outEventStatsCollector) {
                    this._latestDbusRequest.getParams().put(this._outEventStatsCollector.getName(), this._connOutEventStatsCollector);
                }
                if (null != this._outHttpStatsCollector) {
                    this._latestDbusRequest.getParams().put(this._outHttpStatsCollector.getName(), this._connOutHttpStatsCollector);
                }
            } else if (this.shouldMerge(e)) {
                this.mergePerConnStats();
            }
        }
        super.messageReceived(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._connOutEventStatsCollector || null != this._connOutHttpStatsCollector) {
            this.mergePerConnStats();
            if (null != this._connOutEventStatsCollector) {
                this._connOutEventStatsCollector.unregisterMBeans();
            }
            if (null != this._connOutHttpStatsCollector) {
                this._connOutHttpStatsCollector.unregisterMBeans();
            }
            this._connOutEventStatsCollector = null;
            this._connOutHttpStatsCollector = null;
        }
        this._latestDbusRequest = null;
        super.channelClosed(ctx, e);
    }
}

