/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.relay.example;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MultiServerSequenceNumberHandler;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.relay.DatabusRelayMain;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonRelayServer
extends DatabusRelayMain {
    public static final String MODULE = PersonRelayServer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    static final String FULLY_QUALIFIED_PERSON_EVENT_NAME = "com.linkedin.events.example.person.Person";
    static final int PERSON_SRC_ID = 40;
    MultiServerSequenceNumberHandler _maxScnReaderWriters;
    protected Map<PhysicalPartition, EventProducer> _producers;

    public PersonRelayServer() throws IOException, InvalidConfigException, DatabusException {
        this(new HttpRelay.Config(), null);
    }

    public PersonRelayServer(HttpRelay.Config config, PhysicalSourceStaticConfig[] pConfigs) throws IOException, InvalidConfigException, DatabusException {
        this(config.build(), pConfigs);
    }

    public PersonRelayServer(HttpRelay.StaticConfig config, PhysicalSourceStaticConfig[] pConfigs) throws IOException, InvalidConfigException, DatabusException {
        super(config, pConfigs);
    }

    public static void main(String[] args) throws Exception {
        HttpRelay.Cli cli = new HttpRelay.Cli();
        cli.setDefaultPhysicalSrcConfigFiles(new String[]{"conf/sources-person.json"});
        cli.processCommandLineArgs(args);
        cli.parseRelayConfig();
        PhysicalSourceStaticConfig[] pStaticConfigs = cli.getPhysicalSourceStaticConfigs();
        HttpRelay.StaticConfig staticConfig = cli.getRelayConfigBuilder().build();
        DatabusRelayMain serverContainer = new DatabusRelayMain(staticConfig, pStaticConfigs);
        serverContainer.initProducers();
        serverContainer.registerShutdownHook();
        serverContainer.startAndBlock();
    }
}

