/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.example;

import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.log4j.Logger;

public class PersonConsumer
extends AbstractDatabusCombinedConsumer {
    public static final Logger LOG = Logger.getLogger((String)PersonConsumer.class.getName());

    public ConsumerCallbackResult onDataEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        return this.processEvent(event, eventDecoder);
    }

    private ConsumerCallbackResult processEvent(DbusEvent event, DbusEventDecoder eventDecoder) {
        GenericRecord decodedEvent = eventDecoder.getGenericRecord(event, null);
        try {
            Utf8 firstName = (Utf8)decodedEvent.get("firstName");
            Utf8 lastName = (Utf8)decodedEvent.get("lastName");
            Long birthDate = (Long)decodedEvent.get("birthDate");
            Utf8 deleted = (Utf8)decodedEvent.get("deleted");
            LOG.info((Object)("firstName: " + firstName.toString() + ", lastName: " + lastName.toString() + ", birthDate: " + birthDate + ", deleted: " + deleted.toString()));
        }
        catch (Exception e) {
            LOG.error((Object)"error decoding event ", (Throwable)e);
            return ConsumerCallbackResult.ERROR;
        }
        return ConsumerCallbackResult.SUCCESS;
    }
}

