/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.ds;

import com.linkedin.databus2.producers.ds.DbChangeEntry;
import com.linkedin.databus2.producers.ds.PerSourceTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transaction {
    private Map<Integer, PerSourceTransaction> _perSourceTxnEntries = new HashMap<Integer, PerSourceTransaction>();
    private long _sizeInBytes;
    private long _txnReadLatencyNanos;
    private long _txnNanoTimestamp;

    public void mergePerSourceTransaction(PerSourceTransaction newPerSourceTxn) {
        int srcId = newPerSourceTxn.getSrcId();
        if (this._perSourceTxnEntries.containsKey(srcId)) {
            PerSourceTransaction oldPerSourceTxn = this._perSourceTxnEntries.get(srcId);
            for (DbChangeEntry dbe : newPerSourceTxn.getDbChangeEntrySet()) {
                oldPerSourceTxn.mergeDbChangeEntrySet(dbe);
            }
        } else {
            this._perSourceTxnEntries.put(srcId, newPerSourceTxn);
        }
    }

    public PerSourceTransaction getPerSourceTransaction(int srcId) {
        return this._perSourceTxnEntries.get(srcId);
    }

    public long getSizeInBytes() {
        return this._sizeInBytes;
    }

    public void setSizeInBytes(long _sizeInBytes) {
        this._sizeInBytes = _sizeInBytes;
    }

    public long getTxnReadLatencyNanos() {
        return this._txnReadLatencyNanos;
    }

    public void setTxnReadLatencyNanos(long _txnReadLatencyNanos) {
        this._txnReadLatencyNanos = _txnReadLatencyNanos;
    }

    public long getTxnNanoTimestamp() {
        return this._txnNanoTimestamp;
    }

    public void setTxnNanoTimestamp(long _txnNanoTimestamp) {
        this._txnNanoTimestamp = _txnNanoTimestamp;
    }

    public List<PerSourceTransaction> getOrderedPerSourceTransactions() {
        ArrayList<PerSourceTransaction> txns = new ArrayList<PerSourceTransaction>(this._perSourceTxnEntries.values());
        Collections.sort(txns, new Comparator<PerSourceTransaction>(){

            @Override
            public int compare(PerSourceTransaction o1, PerSourceTransaction o2) {
                return new Integer(o1.getSrcId()).compareTo(o2.getSrcId());
            }
        });
        return txns;
    }

    public long getScn() {
        long maxScn = -1L;
        for (PerSourceTransaction t : this._perSourceTxnEntries.values()) {
            maxScn = Math.max(maxScn, t.getScn());
        }
        return maxScn;
    }
}

