/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.db;

import com.linkedin.databus2.producers.db.EventReaderSummary;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

public class ReadEventCycleSummary {
    private final List<EventReaderSummary> _sourceSummaries;
    private final long _endOfWindowScn;
    private final int _totalEventNum;
    private final long _readMillis;
    private long _eventMillis;
    private final String _eventSourceName;
    private long _sizeInBytes;
    private long _elapsedTimeMillis;
    private long _queryTimeMillis;

    public String getEventSourceName() {
        return this._eventSourceName;
    }

    public long getReadMillis() {
        return this._readMillis;
    }

    public int getTotalEventNum() {
        return this._totalEventNum;
    }

    public long getEventMillis() {
        return this._eventMillis;
    }

    public long getElapsedTimeMillis() {
        return this._elapsedTimeMillis;
    }

    public long getQueryTimeMillis() {
        return this._queryTimeMillis;
    }

    public List<EventReaderSummary> getSourceSummaries() {
        return this._sourceSummaries;
    }

    public long getEndOfWindowScn() {
        return this._endOfWindowScn;
    }

    public long getTotalEventSizeInBytes() {
        return this._sizeInBytes;
    }

    public ReadEventCycleSummary(String eventSourceName, List<EventReaderSummary> sourceSummaries, long endOfWindowScn, long readMillis) {
        this._eventSourceName = eventSourceName;
        this._sourceSummaries = Collections.unmodifiableList(sourceSummaries);
        this._endOfWindowScn = endOfWindowScn;
        this._readMillis = readMillis;
        long minTimeProdStart = Long.MAX_VALUE;
        long maxTimeProdEnd = 0L;
        long queryTimeMillis = 0L;
        int sum = 0;
        long evSerMillis = 0L;
        long size = 0L;
        for (EventReaderSummary sourceSummary : this._sourceSummaries) {
            sum += sourceSummary.getNumberOfEvents();
            evSerMillis += sourceSummary.getEventMillis();
            size += sourceSummary.getSizeOfSerializedEvents();
            maxTimeProdEnd = Math.max(maxTimeProdEnd, sourceSummary.getTimeProdEnd());
            minTimeProdStart = Math.min(minTimeProdStart, sourceSummary.getTimeProdStart());
            queryTimeMillis += sourceSummary.getQueryExecTime();
        }
        this._elapsedTimeMillis = maxTimeProdEnd - minTimeProdStart;
        this._totalEventNum = sum;
        this._eventMillis = evSerMillis;
        this._sizeInBytes = size;
        this._queryTimeMillis = queryTimeMillis;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        Formatter fmt = new Formatter(sb);
        double prodRate = this._elapsedTimeMillis == 0L ? 0.0 : (double)this._sizeInBytes / (double)this._elapsedTimeMillis;
        double consRate = this._readMillis == 0L ? 0.0 : (double)this._sizeInBytes / (double)this._readMillis;
        fmt.format("src:%s(%d) #src:%d #evt:%d scn:%d ms:%d sizeInBytes:%d msEvent:%d msTimeElapsed:%d msQueryExec:%d prodRate:%.2f consRate:%.2f", this._eventSourceName, 0, this._sourceSummaries.size(), this._totalEventNum, this._endOfWindowScn, this._readMillis, this._sizeInBytes, this._eventMillis, this._elapsedTimeMillis, this._queryTimeMillis, prodRate, consRate);
        fmt.flush();
        return fmt.toString();
    }
}

