/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.db;

import java.util.Formatter;

public class EventReaderSummary {
    public static final long NO_EVENTS_SCN = -1L;
    public static final String EVENT_LOG_FORMAT = "src:%s(%d) #src:%d #evt:%d scn:%d ms:%d sizeInBytes:%d msEvent:%d msTimeElapsed:%d msQueryExec:%d prodRate:%.2f consRate:%.2f";
    private final short _sourceId;
    private final String _sourceName;
    private final long _endOfPeriodSCN;
    private final int _numberOfEvents;
    private final long _sizeOfSerializedEvents;
    private final long _readMillis;
    private final long _msEvent;
    private final long _timeProdStart;
    private final long _timeProdEnd;
    private final long _queryExecTime;

    public long getReadMillis() {
        return this._readMillis;
    }

    public short getSourceId() {
        return this._sourceId;
    }

    public String getSourceName() {
        return this._sourceName;
    }

    public long getEndOfPeriodSCN() {
        return this._endOfPeriodSCN;
    }

    public int getNumberOfEvents() {
        return this._numberOfEvents;
    }

    public long getSizeOfSerializedEvents() {
        return this._sizeOfSerializedEvents;
    }

    public long getEventMillis() {
        return this._msEvent;
    }

    public long getQueryExecTime() {
        return this._queryExecTime;
    }

    public long getTimeProdStart() {
        return this._timeProdStart;
    }

    public long getTimeProdEnd() {
        return this._timeProdEnd;
    }

    public long getTimeElapsed() {
        return this._timeProdEnd - this._timeProdStart;
    }

    public EventReaderSummary(short sourceId, String sourceName, long endOfPeriodSCN, int numberOfEvents, long sizeOfSerializedEvents, long readMillis, long msEvent, long timeProdStart, long timeProdEnd, long queryExecTime) {
        this._sourceId = sourceId;
        this._sourceName = sourceName;
        this._endOfPeriodSCN = endOfPeriodSCN;
        this._numberOfEvents = numberOfEvents;
        this._sizeOfSerializedEvents = sizeOfSerializedEvents;
        this._readMillis = readMillis;
        this._msEvent = msEvent;
        this._timeProdStart = timeProdStart;
        this._timeProdEnd = timeProdEnd;
        this._queryExecTime = queryExecTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        Formatter fmt = new Formatter(sb);
        long timeElapsed = this.getTimeElapsed();
        double prodRate = timeElapsed == 0L ? 0.0 : (double)this._sizeOfSerializedEvents / (double)timeElapsed;
        double consRate = this._readMillis == 0L ? 0.0 : (double)this._sizeOfSerializedEvents / (double)this._readMillis;
        fmt.format(EVENT_LOG_FORMAT, this._sourceName, this._sourceId, 1, this._numberOfEvents, this._endOfPeriodSCN, this._readMillis, this._sizeOfSerializedEvents, this._msEvent, timeElapsed, this._queryExecTime, prodRate, consRate);
        fmt.flush();
        return fmt.toString();
    }
}

