/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers;

import com.linkedin.databus2.producers.EventProducerServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class RelayEventProducersRegistry {
    private static final RelayEventProducersRegistry THE_INSTANCE = new RelayEventProducersRegistry();
    private final Map<String, EventProducerServiceProvider> _providers = new HashMap<String, EventProducerServiceProvider>();
    private final ServiceLoader<EventProducerServiceProvider> _serviceLoader;
    private final Logger _log = Logger.getLogger(RelayEventProducersRegistry.class);

    private RelayEventProducersRegistry() {
        this._serviceLoader = ServiceLoader.load(EventProducerServiceProvider.class);
        this.loadEventProducerServices();
    }

    private void loadEventProducerServices() {
        for (EventProducerServiceProvider provider : this._serviceLoader) {
            this.register(provider.getUriScheme(), provider);
        }
    }

    public synchronized void register(String uriScheme, EventProducerServiceProvider provider) {
        if (null == provider) {
            throw new NullPointerException("null event producer");
        }
        uriScheme = RelayEventProducersRegistry.normalizeUriScheme(uriScheme);
        this._log.info((Object)("registering relay event producer for scheme " + uriScheme + ": " + provider));
        EventProducerServiceProvider oldProducer = this._providers.put(uriScheme, provider);
        if (null != oldProducer) {
            throw new RuntimeException("overriding old relay event producer for scheme " + uriScheme + ": " + oldProducer);
        }
    }

    public synchronized EventProducerServiceProvider getEventProducerServiceProvider(String uriScheme) {
        return this._providers.get(RelayEventProducersRegistry.normalizeUriScheme(uriScheme));
    }

    private static String normalizeUriScheme(String uriScheme) {
        if (null == uriScheme) {
            throw new NullPointerException("null URI scheme");
        }
        if ((uriScheme = uriScheme.trim()).endsWith(":")) {
            uriScheme = uriScheme.substring(0, uriScheme.length() - 1);
        }
        return uriScheme;
    }

    public static RelayEventProducersRegistry getInstance() {
        return THE_INSTANCE;
    }
}

