/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.monitoring.mbean;

import com.linkedin.databus.monitoring.mbean.EventSourceStatisticsMBean;

public class EventSourceStatistics
implements EventSourceStatisticsMBean {
    private final String _sourceName;
    private int _numConsecutiveCyclesWithEvents;
    private int _numConsecutiveCyclesWithoutEvents;
    private int _numCyclesWithEvents;
    private int _numCyclesWithoutEvents;
    private int _totalEvents;
    private long _totalEventSerializedSize;
    private long _totalEventFactoryTimeMillis;
    private long _lastCycleWithEventsTimestamp;
    private long _maxScn;
    private long _maxDBScn;
    private long _numErrors;
    private long _timestampLastDBAccess;

    public EventSourceStatistics(String sourceName) {
        this._sourceName = sourceName;
    }

    public EventSourceStatistics(String name, int numDataEvents, long timeSinceLastAccess, long maxScn, long numErrors, long sizeDataEvents) {
        this._sourceName = name;
        this._totalEvents = numDataEvents;
        this._timestampLastDBAccess = timeSinceLastAccess;
        this._maxScn = maxScn;
        this._totalEventSerializedSize = sizeDataEvents;
        this._numErrors = numErrors;
        this._totalEventFactoryTimeMillis = 0L;
        this._numConsecutiveCyclesWithEvents = 0;
        this._numConsecutiveCyclesWithoutEvents = 0;
        this._numCyclesWithEvents = 0;
        this._numCyclesWithoutEvents = 0;
        this._lastCycleWithEventsTimestamp = 0L;
    }

    public synchronized void addEmptyEventCycle() {
        this._numConsecutiveCyclesWithEvents = 0;
        ++this._numConsecutiveCyclesWithoutEvents;
        ++this._numCyclesWithoutEvents;
    }

    public synchronized void addEventCycle(int numEvents, long eventFactoryTimeMillis, long eventSerializedSize, long maxScn) {
        if (numEvents > 0) {
            ++this._numConsecutiveCyclesWithEvents;
            this._numConsecutiveCyclesWithoutEvents = 0;
            ++this._numCyclesWithEvents;
            this._totalEvents += numEvents;
            this._totalEventSerializedSize += eventSerializedSize;
            this._totalEventFactoryTimeMillis += eventFactoryTimeMillis;
            this._lastCycleWithEventsTimestamp = System.currentTimeMillis();
            this._maxScn = maxScn;
        } else {
            this.addEmptyEventCycle();
        }
    }

    public synchronized void addError() {
        ++this._numErrors;
    }

    @Override
    public synchronized long getAvgEventFactoryTimeMillisPerEvent() {
        return this._totalEvents != 0 ? this._totalEventFactoryTimeMillis / (long)this._totalEvents : 0L;
    }

    @Override
    public synchronized long getAvgEventSerializedSize() {
        return this._totalEvents != 0 ? this._totalEventSerializedSize / (long)this._totalEvents : 0L;
    }

    @Override
    public synchronized int getAvgNumEventsPerNonEmptyCycle() {
        return this._numCyclesWithEvents != 0 ? this._totalEvents / this._numCyclesWithEvents : 0;
    }

    @Override
    public synchronized int getNumConsecutiveCyclesWithEvents() {
        return this._numConsecutiveCyclesWithEvents;
    }

    @Override
    public synchronized int getNumConsecutiveCyclesWithoutEvents() {
        return this._numConsecutiveCyclesWithoutEvents;
    }

    @Override
    public synchronized int getNumCyclesWithEvents() {
        return this._numCyclesWithEvents;
    }

    @Override
    public synchronized int getNumCyclesWithoutEvents() {
        return this._numCyclesWithoutEvents;
    }

    @Override
    public synchronized String getSourceName() {
        return this._sourceName;
    }

    @Override
    public synchronized int getNumCyclesTotal() {
        return this._numCyclesWithEvents + this._numCyclesWithoutEvents;
    }

    @Override
    public synchronized long getMillisSinceLastCycleWithEvents() {
        return System.currentTimeMillis() - this._lastCycleWithEventsTimestamp;
    }

    @Override
    public synchronized long getMaxScn() {
        return this._maxScn;
    }

    @Override
    public synchronized int getNumTotalEvents() {
        return this._totalEvents;
    }

    @Override
    public synchronized void reset() {
        this._numConsecutiveCyclesWithEvents = 0;
        this._numConsecutiveCyclesWithoutEvents = 0;
        this._numCyclesWithEvents = 0;
        this._numCyclesWithoutEvents = 0;
        this._totalEvents = 0;
        this._totalEventSerializedSize = 0L;
        this._totalEventFactoryTimeMillis = 0L;
        this._lastCycleWithEventsTimestamp = 0L;
        this._maxScn = 0L;
        this._maxDBScn = 0L;
        this._numErrors = 0L;
        this._timestampLastDBAccess = 0L;
    }

    public synchronized void addTimeOfLastDBAccess(long ts) {
        this._timestampLastDBAccess = ts;
    }

    public synchronized void addMaxDBScn(long dbscn) {
        this._maxDBScn = dbscn;
    }

    @Override
    public synchronized long getMaxDBScn() {
        return this._maxDBScn;
    }

    @Override
    public synchronized long getNumErrors() {
        return this._numErrors;
    }

    @Override
    public synchronized long getTimeSinceLastDBAccess() {
        return System.currentTimeMillis() - this._timestampLastDBAccess;
    }
}

