/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.client.util;

import com.linkedin.databus.client.pub.DatabusClientGroupMember;
import com.linkedin.databus.client.pub.DatabusClientNode;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DbusClientClusterUtil {
    public static void main(String[] args) {
        block42: {
            try {
                String[] fns;
                String serverList;
                String sharedDir;
                String groupname;
                String namespace;
                GnuParser cmdLineParser = new GnuParser();
                Options options = new Options();
                options.addOption("n", true, "Zookeeper namespace  [/DatabusClient").addOption("g", true, "Groupname [default-group-name] ").addOption("d", true, "Shared directory name [shareddata] ").addOption("s", true, "Zookeeper server list [localhost:2181] ").addOption("h", false, "help");
                CommandLine cmdLineArgs = cmdLineParser.parse(options, args, false);
                if (cmdLineArgs.hasOption('h')) {
                    DbusClientClusterUtil.usage();
                    System.exit(0);
                }
                if ((namespace = cmdLineArgs.getOptionValue('n')) == null || namespace.isEmpty()) {
                    namespace = "/DatabusClient";
                }
                if ((groupname = cmdLineArgs.getOptionValue('g')) == null || groupname.isEmpty()) {
                    groupname = "default-group-name";
                }
                if ((sharedDir = cmdLineArgs.getOptionValue('d')) == null || sharedDir.isEmpty()) {
                    sharedDir = "shareddata";
                }
                if ((serverList = cmdLineArgs.getOptionValue('s')) == null || serverList.isEmpty()) {
                    serverList = "localhost:2181";
                }
                if ((fns = cmdLineArgs.getArgs()).length < 1) {
                    DbusClientClusterUtil.usage();
                    System.exit(1);
                }
                String function = fns[0];
                String arg1 = fns.length > 1 ? fns[1] : null;
                String arg2 = fns.length > 2 ? fns[2] : null;
                try {
                    String memberName = "cmd-line-tool";
                    DatabusClientNode clusterNode = new DatabusClientNode(new DatabusClientNode.StaticConfig(true, serverList, 2000, 5000, namespace, groupname, memberName, false, sharedDir));
                    DatabusClientGroupMember member = clusterNode.getMember(namespace, groupname, memberName);
                    if (member == null || !member.joinWithoutLeadershipDuties()) {
                        System.err.println("Initialization failed for: " + member);
                        System.exit(1);
                    }
                    if (function.equals("members")) {
                        List mlist = member.getMembers();
                        for (String m : mlist) {
                            System.out.println(m);
                        }
                        break block42;
                    }
                    if (function.equals("leader")) {
                        String leader = member.getLeader();
                        System.out.println(leader);
                        break block42;
                    }
                    if (function.equals("keys")) {
                        List keyList = member.getSharedKeys();
                        if (keyList != null) {
                            for (String m : keyList) {
                                System.out.println(m);
                            }
                        }
                        break block42;
                    }
                    if (function.equals("readSCN")) {
                        ArrayList<String> keyList;
                        if (arg1 == null) {
                            keyList = member.getSharedKeys();
                        } else {
                            keyList = new ArrayList<String>();
                            keyList.add(arg1);
                        }
                        if (keyList != null) {
                            for (String k : keyList) {
                                if (k.equals("dscLastWriteTimestamp")) continue;
                                Checkpoint cp = (Checkpoint)member.readSharedData(k);
                                if (cp != null) {
                                    System.out.println(k + " " + cp.getWindowScn() + " " + cp.getWindowOffset());
                                    continue;
                                }
                                System.err.println(k + " null null");
                            }
                        }
                        break block42;
                    }
                    if (function.equals("writeSCN")) {
                        if (arg1 != null && arg2 != null) {
                            Checkpoint cp = new Checkpoint();
                            cp.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
                            cp.setWindowScn(Long.valueOf(Long.parseLong(arg2)));
                            if (fns.length > 3) {
                                cp.setWindowOffset((long)Integer.parseInt(fns[3]));
                            } else {
                                cp.setWindowOffset(-1L);
                            }
                            if (member.writeSharedData(arg1, (Object)cp)) {
                                System.out.println(arg1 + " " + cp.getWindowScn() + " " + cp.getWindowOffset());
                            } else {
                                System.err.println("Write failed! " + member + " couldn't write key=" + arg1);
                                System.exit(1);
                            }
                        } else {
                            DbusClientClusterUtil.usage();
                            System.exit(1);
                        }
                        break block42;
                    }
                    if (function.equals("readLastTs")) {
                        Long timeInMs = (Long)member.readSharedData("dscLastWriteTimestamp");
                        if (timeInMs != null) {
                            System.out.println("dscLastWriteTimestamp " + timeInMs);
                        } else {
                            System.err.println("dscLastWriteTimestamp null");
                        }
                        break block42;
                    }
                    if (function.equals("writeLastTs")) {
                        if (arg1 != null) {
                            Long ts = Long.parseLong(arg1);
                            if (member.writeSharedData("dscLastWriteTimestamp", (Object)ts)) {
                                System.out.println("dscLastWriteTimestamp " + ts);
                            } else {
                                System.err.println("Write failed! " + member + " couldn't write key=" + "dscLastWriteTimestamp");
                                System.exit(1);
                            }
                        } else {
                            DbusClientClusterUtil.usage();
                            System.exit(1);
                        }
                        break block42;
                    }
                    if (function.equals("remove")) {
                        if (!member.removeSharedData(arg1)) {
                            System.err.println("Remove failed! " + arg1);
                            System.exit(1);
                        }
                        break block42;
                    }
                    if (function.equals("create")) {
                        if (!member.createPaths()) {
                            System.err.println("Create path failed!");
                            System.exit(1);
                        }
                        break block42;
                    }
                    DbusClientClusterUtil.usage();
                    System.exit(1);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                    DbusClientClusterUtil.usage();
                    System.exit(1);
                }
            }
            catch (ParseException e) {
                DbusClientClusterUtil.usage();
                System.exit(1);
            }
        }
    }

    public static void usage() {
        System.err.println(" [ -n <namespace>] [-g <groupname>] [-d <shareddir>] [-s <cluster-server-list>] FUNCTION-NAME");
        System.err.println(" FUNCTION-NAME one of: ");
        System.err.println(" members : lists members belonging to the group <groupname> ");
        System.err.println(" leader: lists the leader of the group <groupname> ");
        System.err.println(" keys: lists the keys written to shared directory <shareddir> ");
        System.err.println(" readSCN [<key>] : reads the SCN written to shared directory <shareddir> ");
        System.err.println(" writeSCN <key> <SCN> [offset] : writes the SCN written to shared directory <shareddir> ");
        System.err.println(" remove <[key]> : removes key  ; all keys if none specified in <shareddir>");
        System.err.println(" readLastTs : reads the last TS");
        System.err.println(" create : create the path if none exists ");
        System.err.println(" writeLastTs <TIMESTAMP> : writes latest TS");
    }
}

