/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.client.util;

import com.linkedin.databus.client.pub.ClusterCheckpointPersistenceProvider;
import com.linkedin.databus.cluster.DatabusCluster;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;

public class DatabusClusterUtil {
    public static Set<Integer> getPartitions(String partition, int numParts) throws DatabusClusterUtilException {
        HashSet<Integer> partList = null;
        if (partition != null && !partition.isEmpty()) {
            String[] partitions = partition.split(",");
            partList = new HashSet(partitions.length);
            for (String pt : partitions) {
                Integer part = Integer.parseInt(pt);
                if (part > numParts) {
                    throw new DatabusClusterUtilException("Partition " + part + " not legal in " + numParts + " partitions");
                }
                partList.add(part);
            }
        } else {
            partList = new HashSet<Integer>(numParts);
            for (int i = 0; i < numParts; ++i) {
                partList.add(i);
            }
        }
        return partList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            String[] fns;
            String partitionStr;
            String partition;
            GnuParser cmdLineParser = new GnuParser();
            Options options = new Options();
            options.addOption("z", true, "zk-server").addOption("c", true, "cluster-name ").addOption("p", true, "partition").addOption("l", false, "legacy").addOption("h", false, "help");
            CommandLine cmdLineArgs = cmdLineParser.parse(options, args, false);
            if (cmdLineArgs.hasOption('h')) {
                DatabusClusterUtil.usage();
                System.exit(0);
            }
            if (!cmdLineArgs.hasOption('c')) {
                DatabusClusterUtil.usage();
                System.exit(1);
            }
            String clusterName = cmdLineArgs.getOptionValue('c');
            String zkServer = cmdLineArgs.getOptionValue('z');
            boolean isLegacyChkptLocation = cmdLineArgs.hasOption('l');
            if (zkServer == null || zkServer.isEmpty()) {
                zkServer = "localhost:2181";
            }
            if ((partition = (partitionStr = cmdLineArgs.getOptionValue('p'))) != null && partition.equals("all")) {
                partition = "";
            }
            if ((fns = cmdLineArgs.getArgs()).length < 1) {
                DatabusClusterUtil.usage();
                System.exit(1);
            }
            DatabusClusterUtilHelper clusterState = new DatabusClusterUtilHelper(zkServer, clusterName);
            String function = fns[0];
            String arg1 = fns.length > 1 ? fns[1] : null;
            String arg2 = fns.length > 2 ? fns[2] : null;
            boolean clusterExists = clusterState.existsCluster();
            if (function.equals("create")) {
                if (clusterExists) throw new DatabusClusterUtilException("Cluster " + clusterName + " already exists");
                if (arg1 == null) {
                    throw new DatabusClusterUtilException("create: please provide the number of partitions");
                }
                int part = Integer.parseInt(arg1);
                clusterState.createCluster(part);
                return;
            }
            if (!clusterExists) {
                throw new DatabusClusterUtilException("Cluster doesn't exist! ");
            }
            if (function.equals("delete")) {
                clusterState.removeCluster();
                return;
            } else if (function.equals("partitions")) {
                int numParts = clusterState.getNumPartitions();
                System.out.println(numParts);
                return;
            } else {
                Set<Integer> partitions = DatabusClusterUtil.getPartitions(partition, clusterState.getNumPartitions());
                if (function.equals("sources")) {
                    DatabusClusterCkptManager ckptMgr = new DatabusClusterCkptManager(zkServer, clusterName, null, partitions, isLegacyChkptLocation);
                    Set<String> sources = ckptMgr.getSourcesFromCheckpoint();
                    if (sources == null) throw new DatabusClusterUtilException("sources: Sources not found for cluster " + clusterName);
                    for (String s : sources) {
                        System.out.println(s);
                    }
                    return;
                } else if (function.equals("clients")) {
                    clusterState.getClusterInfo();
                    for (Integer p : partitions) {
                        String client = clusterState.getInstanceForPartition(p);
                        System.out.println(p + "\t" + client);
                    }
                    return;
                } else if (function.equals("readSCN")) {
                    List<String> sources = DatabusClusterUtil.getSources(arg1);
                    if (sources == null || sources.isEmpty()) throw new DatabusClusterUtilException("readSCN: please specify non-empty sources");
                    DatabusClusterCkptManager ckptMgr = new DatabusClusterCkptManager(zkServer, clusterName, sources, partitions, isLegacyChkptLocation);
                    Map<Integer, Checkpoint> ckpts = ckptMgr.readCheckpoint();
                    char delim = '\t';
                    for (Map.Entry<Integer, Checkpoint> mkPair : ckpts.entrySet()) {
                        StringBuilder output = new StringBuilder(64);
                        output.append(mkPair.getKey());
                        output.append(delim);
                        Checkpoint cp = mkPair.getValue();
                        if (cp == null) {
                            output.append(-1);
                            output.append(delim);
                            output.append(-1);
                        } else if (cp.getConsumptionMode() == DbusClientMode.ONLINE_CONSUMPTION) {
                            output.append(cp.getWindowScn());
                            output.append(delim);
                            output.append(cp.getWindowOffset());
                        } else if (cp.getConsumptionMode() == DbusClientMode.BOOTSTRAP_CATCHUP) {
                            output.append(cp.getWindowScn());
                            output.append(delim);
                            output.append(cp.getWindowOffset());
                        } else if (cp.getConsumptionMode() == DbusClientMode.BOOTSTRAP_SNAPSHOT) {
                            output.append(cp.getBootstrapSinceScn());
                            output.append(delim);
                            output.append(-1);
                        }
                        System.out.println(output.toString());
                    }
                    return;
                } else if (function.equals("checkpoint")) {
                    List<String> sources = DatabusClusterUtil.getSources(arg1);
                    if (sources == null || sources.isEmpty()) throw new DatabusClusterUtilException("readSCN: please specify non-empty sources");
                    DatabusClusterCkptManager ckptMgr = new DatabusClusterCkptManager(zkServer, clusterName, sources, partitions, isLegacyChkptLocation);
                    Map<Integer, Checkpoint> ckpts = ckptMgr.readCheckpoint();
                    char delim = '\t';
                    for (Map.Entry<Integer, Checkpoint> mkPair : ckpts.entrySet()) {
                        StringBuilder output = new StringBuilder(64);
                        output.append(mkPair.getKey());
                        output.append(delim);
                        Checkpoint cp = mkPair.getValue();
                        if (cp == null) {
                            output.append("null");
                        } else {
                            output.append(cp.toString());
                        }
                        System.out.println(output.toString());
                    }
                    return;
                } else if (function.equals("writeSCN")) {
                    String scnStr = arg1;
                    Long scn = Long.parseLong(scnStr);
                    if (partitionStr == null) throw new DatabusClusterUtilException("writeSCN: to write the SCN to all partitions please use '-p all'");
                    List<String> sources = DatabusClusterUtil.getSources(arg2);
                    if (sources == null || sources.isEmpty()) throw new DatabusClusterUtilException("writeSCN: please specify non-empty sources");
                    DatabusClusterCkptManager ckptMgr = new DatabusClusterCkptManager(zkServer, clusterName, sources, partitions, isLegacyChkptLocation);
                    ckptMgr.writeCheckpoint(scn);
                    return;
                } else if (function.equals("removeSCN")) {
                    if (partitionStr == null) throw new DatabusClusterUtilException("remove: to remove SCN from all partitions please use '-p all'");
                    List<String> sources = DatabusClusterUtil.getSources(arg1);
                    if (sources == null || sources.isEmpty()) throw new DatabusClusterUtilException("remove: please specify non-empty sources");
                    DatabusClusterCkptManager ckptMgr = new DatabusClusterCkptManager(zkServer, clusterName, sources, partitions, isLegacyChkptLocation);
                    ckptMgr.remove();
                    return;
                } else {
                    DatabusClusterUtil.usage();
                    System.exit(1);
                }
            }
            return;
        }
        catch (ParseException e) {
            DatabusClusterUtil.usage();
            System.exit(1);
            return;
        }
        catch (DatabusClusterUtilException e) {
            System.err.println("Error! " + e.toString());
            System.exit(1);
        }
    }

    private static List<String> getSources(String arg1) {
        if (arg1 != null) {
            String src = arg1.replaceAll(" ", "");
            String[] sources = src.split(",");
            List<String> sourceList = Arrays.asList(sources);
            return sourceList;
        }
        return null;
    }

    public static void usage() {
        System.err.println(" [ -z <zkAddr> -c <cluster-name>  [-p <partitionNumber1,[partionNumber2,..]>] ] [-l] FUNCTION-NAME [arglist]");
        System.err.println(" FUNCTION-NAME one of: ");
        System.err.println(" readSCN  [source]    :  prints the SCN written to partitions specified with -p or all if none specified for all sources");
        System.err.println(" writeSCN <SCN> [source]: writes the SCN written to partitions specified in -p or all if 'all' specified for all sources");
        System.err.println(" removeSCN [source]       : removes SCN of partitions specified in -p or all if 'all' for all sources unless specified");
        System.err.println(" partitions     : print the number of partitions of specified cluster");
        System.err.println(" clients        : print the partitions to instance mapping for partitions specified in '-p' or all if 'all' is specified ");
        System.err.println(" sources        : print the sources found in specified cluster ");
        System.err.println(" create  <numPartitions>  : create a cluster with specified number of partitions");
        System.err.println(" checkpoint   :  print checkpoints of partitions specified with -p or all if none specified ");
        System.err.println(" delete   : delete a cluster ");
        System.err.println(" Note: [source] is <src1,src2,..,srcN> corresponding to value specified in clients during subscription ");
        System.err.println(" Note: -l if specified writes/reads/removes checkpoints from legacy locations ");
    }

    public static class DatabusClusterUtilException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DatabusClusterUtilException(String msg) {
            super(msg);
        }
    }

    public static class DatabusClusterCkptManager {
        private final ClusterCheckpointPersistenceProvider.Config _clusterConfig = new ClusterCheckpointPersistenceProvider.Config();
        private final Set<Integer> _partitions;
        private final List<String> _sources;
        final boolean _isLegacyCkptLocation;

        public DatabusClusterCkptManager(String zkAddr, String cluster, List<String> sources, Set<Integer> partitions, boolean isLegacyCkptLocation) {
            this._clusterConfig.setClusterName(cluster);
            this._clusterConfig.setZkAddr(zkAddr);
            this._clusterConfig.setCheckpointIntervalMs(1L);
            this._partitions = partitions;
            this._sources = sources;
            this._isLegacyCkptLocation = isLegacyCkptLocation;
        }

        public void writeCheckpoint(long scn) throws DatabusClusterUtilException {
            try {
                for (int p : this._partitions) {
                    ClusterCheckpointPersistenceProvider cpProvider = new ClusterCheckpointPersistenceProvider((long)p, this._clusterConfig);
                    Checkpoint cp = new Checkpoint();
                    cp.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
                    cp.setWindowOffset(-1L);
                    cp.setWindowScn(Long.valueOf(scn));
                    if (this._isLegacyCkptLocation) {
                        cpProvider.storeCheckpointLegacy(this._sources, cp);
                        continue;
                    }
                    cpProvider.storeCheckpoint(this._sources, cp);
                }
            }
            catch (InvalidConfigException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            catch (IOException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            catch (ClusterCheckpointPersistenceProvider.ClusterCheckpointException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
        }

        public Map<Integer, Checkpoint> readCheckpoint() throws DatabusClusterUtilException {
            HashMap<Integer, Checkpoint> list = new HashMap<Integer, Checkpoint>(this._partitions.size());
            try {
                for (int p : this._partitions) {
                    ClusterCheckpointPersistenceProvider cpProvider = new ClusterCheckpointPersistenceProvider((long)p, this._clusterConfig);
                    if (this._isLegacyCkptLocation) {
                        list.put(p, cpProvider.loadCheckpointLegacy(this._sources));
                        continue;
                    }
                    list.put(p, cpProvider.loadCheckpoint(this._sources));
                }
            }
            catch (InvalidConfigException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            catch (ClusterCheckpointPersistenceProvider.ClusterCheckpointException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            return list;
        }

        public void remove() throws DatabusClusterUtilException {
            try {
                for (int p : this._partitions) {
                    ClusterCheckpointPersistenceProvider cpProvider = new ClusterCheckpointPersistenceProvider((long)p, this._clusterConfig);
                    if (this._isLegacyCkptLocation) {
                        cpProvider.removeCheckpointLegacy(this._sources);
                        continue;
                    }
                    cpProvider.removeCheckpoint(this._sources);
                }
            }
            catch (InvalidConfigException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            catch (ClusterCheckpointPersistenceProvider.ClusterCheckpointException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
        }

        public Set<String> getSourcesFromCheckpoint() throws DatabusClusterUtilException {
            try {
                ClusterCheckpointPersistenceProvider cpProvider = new ClusterCheckpointPersistenceProvider(0L, this._clusterConfig);
                return cpProvider.getSourceNames();
            }
            catch (InvalidConfigException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
            catch (ClusterCheckpointPersistenceProvider.ClusterCheckpointException e) {
                throw new DatabusClusterUtilException(e.toString());
            }
        }
    }

    public static class DatabusClusterUtilHelper {
        protected final ZkClient _zkClient;
        protected final ZKHelixAdmin _admin;
        protected final String _clusterName;
        List<String> _instances = null;
        private HashMap<Integer, String> _partitionMap = new HashMap(100);

        public DatabusClusterUtilHelper(String zkAddr, String clusterName) {
            this._clusterName = clusterName;
            this._zkClient = new ZkClient(zkAddr, 30000, 60000, (ZkSerializer)new ZNRecordSerializer());
            this._admin = new ZKHelixAdmin(this._zkClient);
        }

        public void getClusterInfo() {
            List<String> resources = this.getResources();
            if (resources.size() < 1) {
                System.err.println("Error! No resources found in cluster  " + this._clusterName);
                return;
            }
            IdealState idealState = this._admin.getResourceIdealState(this._clusterName, resources.get(0));
            idealState.getNumPartitions();
            ExternalView v = this._admin.getResourceExternalView(this._clusterName, resources.get(0));
            if (v == null) {
                System.err.println("No instances running for cluster= " + this._clusterName + " resource= " + resources.get(0));
                return;
            }
            this._partitionMap.clear();
            for (String k : v.getPartitionSet()) {
                Map map = v.getStateMap(k);
                if (map == null) continue;
                for (Map.Entry mkPair : map.entrySet()) {
                    String value = (String)mkPair.getValue();
                    if (value == null) continue;
                    Integer partition = this.getPartition(k);
                    if (!value.equals("ONLINE")) continue;
                    this._partitionMap.put(partition, (String)mkPair.getKey());
                }
            }
        }

        public List<String> getResources() {
            return this._admin.getResourcesInCluster(this._clusterName);
        }

        public void createCluster(int numPartitions) {
            int part = DatabusCluster.create((ZKHelixAdmin)this._admin, (ZkClient)this._zkClient, (String)this._clusterName, (int)numPartitions);
            if (part < 0) {
                throw new RuntimeException("Unable to create cluster (" + this._clusterName + ") !!");
            }
        }

        public void removeCluster() {
            this._admin.dropCluster(this._clusterName);
        }

        public boolean existsCluster() {
            try {
                List<String> resources = this.getResources();
                return resources != null && !resources.isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }

        public List<String> getInstances() {
            this._instances = this._admin.getInstancesInCluster(this._clusterName);
            return this._instances;
        }

        public String getInstanceForPartition(Integer partition) {
            return this._partitionMap.get(partition);
        }

        public int getNumPartitions() {
            IdealState idealState;
            List<String> resources = this.getResources();
            if (resources != null && !resources.isEmpty() && (idealState = this._admin.getResourceIdealState(this._clusterName, resources.get(0))) != null) {
                return idealState.getNumPartitions();
            }
            return -1;
        }

        public Set<Integer> getPartitionList() {
            return this._partitionMap.keySet();
        }

        private Integer getPartition(String partition) {
            String[] ps = partition.split("_");
            if (ps.length >= 2) {
                return Integer.parseInt(ps[ps.length - 1]);
            }
            return -1;
        }
    }
}

