/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.groupleader.impl.zkclient;

import com.linkedin.databus.groupleader.pub.AcceptLeadershipCallback;
import com.linkedin.databus.groupleader.pub.GroupLeadershipConnection;
import com.linkedin.databus.groupleader.pub.GroupLeadershipInfo;
import com.linkedin.databus.groupleader.pub.GroupLeadershipSession;
import com.linkedin.databus.groupleader.pub.GroupMemberInfo;
import com.linkedin.databus.groupleader.pub.GroupsLeadershipInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;

public class GroupLeadershipConnectionZkClientImpl
implements GroupLeadershipConnection {
    private static final Logger LOG = Logger.getLogger(GroupLeadershipConnectionZkClientImpl.class);
    protected static final String GROUPS_ZK_PATH_PART = "groups";
    protected static final String MEMBERS_ZK_PATH_PART = "members";
    protected static final String LEADER_ZK_PATH_PART = "leader";
    protected static final String SHARED_DATA_ZK_PATH_PART = "shareddata";
    private final ZkClient _zkClient;

    protected static String makeUniqueMemberName() {
        return UUID.randomUUID().toString();
    }

    protected static String makeGroupsNodePath(String baseZkPath) {
        return baseZkPath + "/" + GROUPS_ZK_PATH_PART;
    }

    static String makeGroupNodePath(String baseZkPath, String groupName) {
        return GroupLeadershipConnectionZkClientImpl.makeGroupsNodePath(baseZkPath) + "/" + groupName;
    }

    static String makeGroupSharedDataNodePath(String baseZkPath, String groupName, String sharedDataPath) {
        return GroupLeadershipConnectionZkClientImpl.makeGroupsNodePath(baseZkPath) + "/" + groupName + "/" + sharedDataPath;
    }

    static String makeMembersNodePath(String baseZkPath, String groupName) {
        return GroupLeadershipConnectionZkClientImpl.makeGroupNodePath(baseZkPath, groupName) + "/" + MEMBERS_ZK_PATH_PART;
    }

    static String makeMemberNodePath(String baseZkPath, String groupName, String memberName) {
        return GroupLeadershipConnectionZkClientImpl.makeGroupNodePath(baseZkPath, groupName) + "/" + MEMBERS_ZK_PATH_PART + "/" + memberName;
    }

    static String makeLeaderNodePath(String baseZkPath, String groupName) {
        return GroupLeadershipConnectionZkClientImpl.makeGroupNodePath(baseZkPath, groupName) + "/" + LEADER_ZK_PATH_PART;
    }

    public GroupLeadershipConnectionZkClientImpl(ZkClient zkClient) {
        this._zkClient = zkClient;
    }

    protected String ensurePersistentPathExists(String path) {
        if (!this._zkClient.exists(path)) {
            this._zkClient.createPersistent(path, true);
        }
        return path;
    }

    protected String ensurePersistentGroupsZkPathExists(String baseZkPath) {
        String groupsZkPath = GroupLeadershipConnectionZkClientImpl.makeGroupsNodePath(baseZkPath);
        return this.ensurePersistentPathExists(groupsZkPath);
    }

    protected String ensurePersistentMembersZkPathExists(String baseZkPath, String groupName) {
        String membersZkPath = GroupLeadershipConnectionZkClientImpl.makeMembersNodePath(baseZkPath, groupName);
        return this.ensurePersistentPathExists(membersZkPath);
    }

    public GroupLeadershipSession joinGroup(String baseZkPath, String groupName, String memberName, AcceptLeadershipCallback acceptLeadershipCallback) {
        String resolvedMemberName = memberName == null ? GroupLeadershipConnectionZkClientImpl.makeUniqueMemberName() : memberName;
        LOG.info((Object)("joinGroup: groupName=" + groupName + "; memberName=" + memberName + "; resolvedMemberName=" + resolvedMemberName));
        this.ensurePersistentMembersZkPathExists(baseZkPath, groupName);
        final GroupLeadershipSessionZkClientImpl groupLeadershipSession = new GroupLeadershipSessionZkClientImpl(baseZkPath, groupName, resolvedMemberName, acceptLeadershipCallback);
        IZkChildListener childListener = new IZkChildListener(){

            public void handleChildChange(String parentPath, List<String> currentChildren) throws Exception {
                GroupLeadershipConnectionZkClientImpl.this.takeLeadershipIfNeeded(groupLeadershipSession);
            }
        };
        IZkDataListener dataListener = new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) throws Exception {
                LOG.info((Object)("LeaderElection: Data change in: " + dataPath));
                GroupLeadershipConnectionZkClientImpl.this.takeLeadershipIfNeeded(groupLeadershipSession);
            }

            public void handleDataDeleted(String dataPath) throws Exception {
                GroupLeadershipConnectionZkClientImpl.this.relinquishLeadership(groupLeadershipSession);
            }
        };
        groupLeadershipSession.setListener(childListener);
        groupLeadershipSession.setDataListener(dataListener);
        String memberPath = GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(baseZkPath, groupName, memberName);
        String path = this._zkClient.createEphemeralSequential(memberPath, (Object)groupLeadershipSession.getUniqueID());
        groupLeadershipSession.setMemberZkName(memberName + path.substring(path.length() - 10));
        String dataWatchPath = GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(baseZkPath, groupName, groupLeadershipSession.getMemberZkName());
        LOG.info((Object)("Created path:" + path + " zkName = " + groupLeadershipSession.getMemberZkName() + " data watch path: " + dataWatchPath));
        this._zkClient.subscribeDataChanges(dataWatchPath, dataListener);
        this.takeLeadershipIfNeeded(groupLeadershipSession);
        return groupLeadershipSession;
    }

    public boolean createBasePath(String baseZkPath, String groupName) {
        String path = GroupLeadershipConnectionZkClientImpl.makeGroupNodePath(baseZkPath, groupName);
        String paths = this.ensurePersistentPathExists(path);
        return paths != null;
    }

    public GroupLeadershipSession joinGroupWithoutLeadershipDuties(String domainName, String groupName, String name) {
        GroupLeadershipSessionZkClientImpl groupLeadershipSession = new GroupLeadershipSessionZkClientImpl(domainName, groupName, name, null);
        return groupLeadershipSession;
    }

    protected void leaveGroup(GroupLeadershipSession groupLeadershipSession) {
        LOG.info((Object)("leaveGroup: groupName=" + groupLeadershipSession.getGroupName() + "; memberName=" + groupLeadershipSession.getMemberName()));
        if (!(groupLeadershipSession instanceof GroupLeadershipSessionZkClientImpl)) {
            throw new IllegalArgumentException("groupLeadershipSession must be an instance of: " + GroupLeadershipSessionZkClientImpl.class.getName());
        }
        GroupLeadershipSessionZkClientImpl zkLeadershipSession = (GroupLeadershipSessionZkClientImpl)groupLeadershipSession;
        zkLeadershipSession.unsubscribeChanges();
        zkLeadershipSession.unsubscribeDataChanges();
        this.ensurePersistentMembersZkPathExists(zkLeadershipSession.getBasePathName(), zkLeadershipSession.getGroupName());
        this._zkClient.delete(GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(zkLeadershipSession.getBasePathName(), zkLeadershipSession.getGroupName(), zkLeadershipSession.getMemberZkName()));
        if (zkLeadershipSession.isLeader()) {
            String leaderZkPath = GroupLeadershipConnectionZkClientImpl.makeLeaderNodePath(zkLeadershipSession.getBasePathName(), zkLeadershipSession.getGroupName());
            this._zkClient.delete(leaderZkPath);
        }
    }

    public String getLeaderName(String baseZkPath, String groupName) {
        String leader = this.getLeaderZkName(baseZkPath, groupName);
        if (leader != null && leader.length() > 10) {
            leader = leader.substring(0, leader.length() - 10);
        }
        return leader;
    }

    public String getLeaderZkName(String baseZkPath, String groupName) {
        String leaderZkPath = GroupLeadershipConnectionZkClientImpl.makeLeaderNodePath(baseZkPath, groupName);
        String currentLeader = (String)this._zkClient.readData(leaderZkPath, true);
        return currentLeader;
    }

    public boolean isLeader(String baseZkPath, String groupName, String memberName) {
        String leaderZkName = this.getLeaderZkName(baseZkPath, groupName);
        if (leaderZkName != null) {
            return memberName.equals(leaderZkName);
        }
        return false;
    }

    public List<String> getGroupNames(String baseZkPath) {
        String groupsZkPath = this.ensurePersistentGroupsZkPathExists(baseZkPath);
        List groupNames = this._zkClient.getChildren(groupsZkPath);
        return groupNames;
    }

    public GroupsLeadershipInfo getGroupsLeadershipInfo(String baseZkPath) {
        List<String> sortedGroupNames = this.getGroupNames(baseZkPath);
        Collections.sort(sortedGroupNames);
        ArrayList<GroupLeadershipInfo> sortedGroupLeadershipInfos = new ArrayList<GroupLeadershipInfo>();
        for (String groupName : sortedGroupNames) {
            GroupLeadershipInfo groupLeadershipInfo = this.getGroupLeadershipInfo(baseZkPath, groupName);
            sortedGroupLeadershipInfos.add(groupLeadershipInfo);
        }
        GroupsLeadershipInfo groupsLeadershipInfo = new GroupsLeadershipInfo(Collections.unmodifiableList(sortedGroupNames), Collections.unmodifiableList(sortedGroupLeadershipInfos));
        return groupsLeadershipInfo;
    }

    public GroupLeadershipInfo getGroupLeadershipInfo(String baseZkPath, String groupName) {
        String membersZkPath = this.ensurePersistentMembersZkPathExists(baseZkPath, groupName);
        List sortedMemberNames = this._zkClient.getChildren(membersZkPath);
        for (int i = 0; i < sortedMemberNames.size(); ++i) {
            sortedMemberNames.set(i, ((String)sortedMemberNames.get(i)).substring(0, ((String)sortedMemberNames.get(i)).length() - 10));
        }
        Collections.sort(sortedMemberNames);
        String leaderName = this.getLeaderName(baseZkPath, groupName);
        ArrayList<GroupMemberInfo> sortedMemberInfos = new ArrayList<GroupMemberInfo>();
        for (String memberName : sortedMemberNames) {
            GroupMemberInfo groupMemberInfo = new GroupMemberInfo(groupName, memberName, memberName.equals(leaderName));
            sortedMemberInfos.add(groupMemberInfo);
        }
        GroupLeadershipInfo groupLeadershipInfo = new GroupLeadershipInfo(groupName, leaderName, Collections.unmodifiableList(sortedMemberNames), Collections.unmodifiableList(sortedMemberInfos));
        return groupLeadershipInfo;
    }

    private void takeLeadershipIfNeeded(GroupLeadershipSessionZkClientImpl groupLeadershipSession) {
        String baseZkPath = groupLeadershipSession.getBasePathName();
        String groupName = groupLeadershipSession.getGroupName();
        String memberName = groupLeadershipSession.getMemberName();
        String leaderZkPath = GroupLeadershipConnectionZkClientImpl.makeLeaderNodePath(baseZkPath, groupName);
        String currentLeader = (String)this._zkClient.readData(leaderZkPath, true);
        String membersZkPath = this.ensurePersistentMembersZkPathExists(baseZkPath, groupName);
        List currentMembers = this._zkClient.getChildren(membersZkPath);
        LOG.info((Object)("takeLeadershipIfNeeded: groupName=" + groupName + "; memberName=" + memberName + "; currentLeader=" + currentLeader + "; members=" + currentMembers));
        LeadershipAction leadershipAction = LeadershipAction.DECLINED_LEADERSHIP;
        String newLeaderZkName = groupLeadershipSession.subscribeChangesOnHigherPriorityLeader();
        if (newLeaderZkName != null) {
            if (newLeaderZkName.equals(groupLeadershipSession.getMemberZkName())) {
                if (currentLeader == null || !currentLeader.equals(newLeaderZkName)) {
                    this.takeLeadership(groupLeadershipSession);
                    leadershipAction = LeadershipAction.TOOK_LEADERSHIP;
                    groupLeadershipSession.doAcceptLeadership();
                } else {
                    LOG.info((Object)("takeLeadershipIfNeeded: Current Leader is same as this node; the new leader! Do nothing! Leader= " + currentLeader + " node=" + newLeaderZkName));
                }
            } else {
                LOG.info((Object)("takeLeaderShipIfNeeded: " + memberName + " declined leadership in favour of leader " + newLeaderZkName));
            }
        } else {
            LOG.info((Object)("takeLeadershipIfNeeded: No nodes seen yet! Declined leadership at " + groupLeadershipSession.getMemberName()));
        }
        List uponExitMembers = this._zkClient.getChildren(membersZkPath);
        String uponExitLeader = (String)this._zkClient.readData(leaderZkPath, true);
        String msg = "takeLeadershipIfNeeded: " + (Object)((Object)leadershipAction) + "; groupName=" + groupName + "; memberName=" + memberName + "; uponExitLeader=" + uponExitLeader + "; uponExitMembers=" + uponExitMembers;
        if (leadershipAction == LeadershipAction.NONE) {
            LOG.warn((Object)("Unexpected leadershipAction: " + msg));
        } else {
            LOG.info((Object)msg);
        }
    }

    private void relinquishLeadership(GroupLeadershipSessionZkClientImpl groupLeadershipSession) {
        LOG.info((Object)("Relinquishing leadership: " + groupLeadershipSession.getMemberZkName()));
        groupLeadershipSession.unsubscribeChanges();
        groupLeadershipSession.unsubscribeDataChanges();
    }

    private boolean takeLeadership(GroupLeadershipSessionZkClientImpl groupLeadershipSession) {
        String leaderZkPath = GroupLeadershipConnectionZkClientImpl.makeLeaderNodePath(groupLeadershipSession.getBasePathName(), groupLeadershipSession.getGroupName());
        if (this._zkClient.exists(leaderZkPath)) {
            LOG.info((Object)(leaderZkPath + " exists! Issuing delete at " + groupLeadershipSession.getMemberZkName()));
            this._zkClient.delete(leaderZkPath);
        }
        this._zkClient.createEphemeral(leaderZkPath, (Object)groupLeadershipSession.getMemberZkName());
        groupLeadershipSession.unsubscribeChanges();
        return true;
    }

    ZkClient getZkClient() {
        return this._zkClient;
    }

    public void close() {
        this._zkClient.close();
    }

    class ZkSeqComparator
    implements Comparator<String> {
        ZkSeqComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            String s = s1.substring(s1.length() - 10);
            return s.compareTo(s2.substring(s2.length() - 10));
        }
    }

    protected class GroupLeadershipSessionZkClientImpl
    implements GroupLeadershipSession {
        private final String _groupName;
        private final String _memberName;
        private final String _basePathName;
        private final AcceptLeadershipCallback _acceptLeadershipCallback;
        private final String _uniqueID;
        private IZkChildListener _childListener;
        private boolean _hasLeftGroup;
        private final Logger LOG = Logger.getLogger(GroupLeadershipSessionZkClientImpl.class);
        private IZkDataListener _dataListener;
        private final ZkSeqComparator _comparator;
        private String _memberZkName;
        private String _listeningMemberZkName;
        private String _sharedDataPath = "shareddata";

        public GroupLeadershipSessionZkClientImpl(String basePathName, String groupName, String memberName, AcceptLeadershipCallback acceptLeadershipCallback) {
            this._groupName = groupName;
            this._memberName = memberName;
            this._basePathName = basePathName;
            this._acceptLeadershipCallback = acceptLeadershipCallback;
            this._uniqueID = UUID.randomUUID().toString();
            this._comparator = new ZkSeqComparator();
            this._memberZkName = null;
            this._listeningMemberZkName = null;
        }

        public String getListeningMemberZkName() {
            return this._listeningMemberZkName;
        }

        public void setListeningMemberZkName(String listenPath) {
            this._listeningMemberZkName = listenPath;
        }

        public void setMemberZkName(String memberZkPath) {
            this._memberZkName = memberZkPath;
        }

        public String getMemberZkName() {
            return this._memberZkName;
        }

        protected void setDataListener(IZkDataListener dataListener) {
            this._dataListener = dataListener;
        }

        public String getUniqueID() {
            return this._uniqueID;
        }

        public GroupLeadershipConnection getGroupLeadershipConnection() {
            return GroupLeadershipConnectionZkClientImpl.this;
        }

        protected GroupLeadershipConnectionZkClientImpl getGroupLeadershipConnectionInternal() {
            return GroupLeadershipConnectionZkClientImpl.this;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public String getMemberName() {
            return this._memberName;
        }

        public AcceptLeadershipCallback getAcceptLeadershipCallback() {
            return this._acceptLeadershipCallback;
        }

        protected void setListener(IZkChildListener childListener) {
            this._childListener = childListener;
        }

        protected void subscribeChanges(String zkMemberName) {
            this.unsubscribeChanges();
            String memberPath = GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(this._basePathName, this._groupName, zkMemberName);
            this.LOG.info((Object)("Adding listener on: " + memberPath + " by: " + this.getMemberZkName()));
            GroupLeadershipConnectionZkClientImpl.this._zkClient.subscribeChildChanges(memberPath, this._childListener);
            this._listeningMemberZkName = zkMemberName;
        }

        protected String subscribeChangesOnHigherPriorityLeader() {
            boolean done = false;
            List memberZkNames = null;
            while (!done) {
                String membersZkPath = GroupLeadershipConnectionZkClientImpl.this.ensurePersistentMembersZkPathExists(this._basePathName, this._groupName);
                memberZkNames = GroupLeadershipConnectionZkClientImpl.this._zkClient.getChildren(membersZkPath);
                this.sortByLeaderPriority(memberZkNames);
                int idx = memberZkNames.indexOf(this.getMemberZkName());
                if (idx > 0) {
                    do {
                        String higherPriorityLeaderZkName;
                        if (!(higherPriorityLeaderZkName = (String)memberZkNames.get(--idx)).equals(this.getListeningMemberZkName())) {
                            this.subscribeChanges(higherPriorityLeaderZkName);
                        }
                        String higherPriorityLeaderZkPath = GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(this._basePathName, this._groupName, higherPriorityLeaderZkName);
                        done = GroupLeadershipConnectionZkClientImpl.this._zkClient.exists(higherPriorityLeaderZkPath);
                        if (done) continue;
                        this.LOG.info((Object)("subscribeChangesOnHigherPriorityLeader: " + this.getMemberZkName() + "Potential race avoided! " + higherPriorityLeaderZkPath + " not present! "));
                    } while (!done && idx > 0);
                    continue;
                }
                done = true;
            }
            return memberZkNames != null && memberZkNames.size() > 0 ? (String)memberZkNames.get(0) : null;
        }

        protected void unsubscribeChanges() {
            if (this._listeningMemberZkName != null) {
                GroupLeadershipConnectionZkClientImpl.this.ensurePersistentMembersZkPathExists(this._basePathName, this._groupName);
                this.LOG.info((Object)("Removing listener on: " + this.getListeningMemberZkName() + " by: " + this.getMemberZkName()));
                GroupLeadershipConnectionZkClientImpl.this._zkClient.unsubscribeChildChanges(this.makeCurrentListeningOnMemberPath(), this._childListener);
            }
        }

        protected String makeCurrentListeningOnMemberPath() {
            String currentListeningMemberPath = GroupLeadershipConnectionZkClientImpl.makeMemberNodePath(this._basePathName, this._groupName, this._listeningMemberZkName);
            return currentListeningMemberPath;
        }

        protected void unsubscribeDataChanges() {
            if (this._dataListener != null) {
                this.LOG.info((Object)("Removing data listener on: " + this.getMemberZkName()));
                GroupLeadershipConnectionZkClientImpl.this._zkClient.unsubscribeDataChanges(this.getMemberZkName(), this._dataListener);
            }
        }

        protected void sortByLeaderPriority(List<String> memberNames) {
            Collections.sort(memberNames, this._comparator);
        }

        public boolean isLeader() {
            return this.getGroupLeadershipConnection().isLeader(this.getBasePathName(), this.getGroupName(), this.getMemberZkName());
        }

        public String getLeaderName() {
            return this.getGroupLeadershipConnection().getLeaderName(this.getBasePathName(), this.getGroupName());
        }

        public String getLeaderZkName() {
            GroupLeadershipConnection conn = this.getGroupLeadershipConnection();
            if (conn instanceof GroupLeadershipConnectionZkClientImpl) {
                return ((GroupLeadershipConnectionZkClientImpl)conn).getLeaderZkName(this.getBasePathName(), this.getGroupName());
            }
            return null;
        }

        public void leaveGroup() {
            if (this._hasLeftGroup) {
                throw new IllegalStateException("This session has already left the group: " + this);
            }
            this.getGroupLeadershipConnectionInternal().leaveGroup(this);
            this._hasLeftGroup = true;
        }

        protected void doAcceptLeadership() {
            this._acceptLeadershipCallback.doAcceptLeadership((GroupLeadershipSession)this);
        }

        public GroupLeadershipInfo getGroupLeadershipInfo() {
            return this.getGroupLeadershipConnection().getGroupLeadershipInfo(this.getBasePathName(), this.getGroupName());
        }

        public String toString() {
            return "basePathName=" + this._basePathName + " ; groupName=" + this._groupName + "; memberName=" + this._memberName + "; uniqueID=" + this._uniqueID + "; listeningOnMemberName=" + this._listeningMemberZkName + "; hasLeftGroup=" + this._hasLeftGroup + "; leadershipInfo=" + this.getGroupLeadershipInfo();
        }

        public String getBasePathName() {
            return this._basePathName;
        }

        public Object readGroupData() {
            return this.readGroupData(null);
        }

        public Object readGroupData(String key) {
            String groupNodePath = GroupLeadershipConnectionZkClientImpl.makeGroupSharedDataNodePath(this.getBasePathName(), this.getGroupName(), this.getSharedDataPath());
            if (key != null) {
                groupNodePath = groupNodePath + "/" + key;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("reading data from: " + groupNodePath));
            }
            return GroupLeadershipConnectionZkClientImpl.this._zkClient.readData(groupNodePath, true);
        }

        public boolean writeGroupData(Object obj) {
            return this.writeGroupData(null, obj);
        }

        protected void createPersistentSharedDataNode() {
            String groupNodePath = GroupLeadershipConnectionZkClientImpl.makeGroupSharedDataNodePath(this.getBasePathName(), this.getGroupName(), this.getSharedDataPath());
            if (!GroupLeadershipConnectionZkClientImpl.this._zkClient.exists(groupNodePath)) {
                this.LOG.info((Object)("creating data node: " + groupNodePath));
                GroupLeadershipConnectionZkClientImpl.this._zkClient.createPersistent(groupNodePath, null);
            }
        }

        public boolean writeGroupData(String key, Object obj) {
            String groupNodePath = GroupLeadershipConnectionZkClientImpl.makeGroupSharedDataNodePath(this.getBasePathName(), this.getGroupName(), this.getSharedDataPath());
            this.createPersistentSharedDataNode();
            if (null != key) {
                groupNodePath = groupNodePath + "/" + key;
                if (!GroupLeadershipConnectionZkClientImpl.this._zkClient.exists(groupNodePath)) {
                    this.LOG.info((Object)("creating data node: " + groupNodePath));
                    GroupLeadershipConnectionZkClientImpl.this._zkClient.createPersistent(groupNodePath, obj);
                    return true;
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("writing data to: " + groupNodePath));
            }
            GroupLeadershipConnectionZkClientImpl.this._zkClient.writeData(groupNodePath, obj);
            return true;
        }

        public boolean removeGroupData() {
            return this.removeGroupData(null);
        }

        public boolean removeGroupData(String key) {
            String groupNodePath = GroupLeadershipConnectionZkClientImpl.makeGroupSharedDataNodePath(this.getBasePathName(), this.getGroupName(), this.getSharedDataPath());
            if (key == null) {
                this.LOG.info((Object)("removing data node: " + groupNodePath));
                return GroupLeadershipConnectionZkClientImpl.this._zkClient.deleteRecursive(groupNodePath);
            }
            this.LOG.info((Object)("removing data node: " + groupNodePath + "/" + key));
            return GroupLeadershipConnectionZkClientImpl.this._zkClient.delete(groupNodePath + "/" + key);
        }

        public String getSharedDataPath() {
            return this._sharedDataPath;
        }

        public void setSharedDataPath(String sharedDataPath) {
            this._sharedDataPath = sharedDataPath;
        }

        public List<String> getKeysOfGroupData() {
            String groupNodePath = GroupLeadershipConnectionZkClientImpl.makeGroupSharedDataNodePath(this.getBasePathName(), this.getGroupName(), this.getSharedDataPath());
            if (GroupLeadershipConnectionZkClientImpl.this._zkClient.exists(groupNodePath)) {
                return GroupLeadershipConnectionZkClientImpl.this._zkClient.getChildren(groupNodePath);
            }
            return null;
        }
    }

    private static enum LeadershipAction {
        NONE,
        TOOK_LEADERSHIP,
        RETAINED_LEADERSHIP,
        DECLINED_LEADERSHIP;

    }
}

