/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.groupleader.pub;

import com.linkedin.databus.groupleader.pub.GroupMemberInfo;
import java.util.List;

public class GroupLeadershipInfo {
    public final String _groupName;
    public final String _leaderName;
    public final List<String> _memberNames;
    public final List<GroupMemberInfo> _groupMemberInfos;

    public GroupLeadershipInfo(String groupName, String leaderName, List<String> memberNames, List<GroupMemberInfo> groupMemberInfos) {
        this._groupName = groupName;
        this._leaderName = leaderName;
        this._memberNames = memberNames;
        this._groupMemberInfos = groupMemberInfos;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getLeaderName() {
        return this._leaderName;
    }

    public List<String> getMemberNames() {
        return this._memberNames;
    }

    public List<GroupMemberInfo> getMemberInfos() {
        return this._groupMemberInfos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._groupName);
        sb.append(": ");
        sb.append("{ ");
        boolean isFirstMember = true;
        for (GroupMemberInfo groupMemberInfo : this._groupMemberInfos) {
            if (!isFirstMember) {
                sb.append(", ");
            }
            sb.append(groupMemberInfo.getMemberName());
            if (groupMemberInfo.isLeader()) {
                sb.append(" [LEADER]");
            }
            isFirstMember = false;
        }
        sb.append(" }");
        return sb.toString();
    }
}

