/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import com.linkedin.databus2.tools.dtail.GenericRecordDtailPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class JsonDtailPrinter
extends GenericRecordDtailPrinter {
    public static final Logger LOG = Logger.getLogger(JsonDtailPrinter.class);

    public JsonDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out) {
        super(client, conf, out, DtailPrinter.MetadataOutput.NONE);
    }

    public JsonDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out, DtailPrinter.MetadataOutput metadata) {
        super(client, conf, out, metadata);
    }

    @Override
    public ConsumerCallbackResult printGenericRecord(GenericRecord r) {
        ConsumerCallbackResult result = ConsumerCallbackResult.SUCCESS;
        try {
            this._out.write(r.toString().getBytes(Charset.defaultCharset()));
            this._out.write(10);
        }
        catch (RuntimeException re) {
            LOG.error((Object)("event dump error: " + re.getMessage()), (Throwable)re);
            result = ConsumerCallbackResult.ERROR;
        }
        catch (IOException ioe) {
            LOG.error((Object)("event dump error: " + ioe.getMessage()), (Throwable)ioe);
            result = ConsumerCallbackResult.ERROR;
        }
        return result;
    }
}

