/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public abstract class GenericRecordDtailPrinter
extends DtailPrinter {
    protected DtailPrinter.MetadataOutput _metadataOutput;

    public GenericRecordDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out, DtailPrinter.MetadataOutput metadataOutput) {
        super(client, conf, out);
        this._metadataOutput = metadataOutput;
    }

    @Override
    public ConsumerCallbackResult printEvent(DbusEventInternalReadable e, DbusEventDecoder eventDecoder) {
        DbusEventAvroDecoder avroDecoder = (DbusEventAvroDecoder)eventDecoder;
        switch (this._metadataOutput) {
            case NONE: {
                GenericRecord payload = eventDecoder.getGenericRecord((DbusEvent)e, null);
                return payload != null ? this.printGenericRecord(payload) : ConsumerCallbackResult.SUCCESS;
            }
            case ONLY: {
                GenericRecord metadata = avroDecoder.getMetadata((DbusEvent)e, null);
                return null != metadata ? this.printGenericRecord(metadata) : ConsumerCallbackResult.SUCCESS;
            }
            case INCLUDE: {
                GenericRecord payload1 = avroDecoder.getGenericRecord((DbusEvent)e, null);
                GenericRecord metadata1 = avroDecoder.getMetadata((DbusEvent)e, null);
                Schema pschema = Schema.createUnion(Arrays.asList(avroDecoder.getPayloadSchema((DbusEvent)e).getSchema(), Schema.create((Schema.Type)Schema.Type.NULL)));
                Schema.Field pfield = new Schema.Field("payload", pschema, "payload", null);
                VersionedSchema metaschema = avroDecoder.getMetadataSchema((DbusEvent)e);
                Schema mschema = null != metaschema ? Schema.createUnion(Arrays.asList(metaschema.getSchema(), Schema.create((Schema.Type)Schema.Type.NULL))) : Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.NULL)));
                Schema.Field mfield = new Schema.Field("metadata", mschema, "metadata", null);
                Schema combined = Schema.createRecord(Arrays.asList(pfield, mfield));
                GenericData.Record r = new GenericData.Record(combined);
                r.put(0, (Object)payload1);
                r.put(1, (Object)metadata1);
                return this.printGenericRecord((GenericRecord)r);
            }
        }
        LOG.error((Object)("unknown metadata output mode: " + (Object)((Object)this._metadataOutput)));
        return ConsumerCallbackResult.ERROR_FATAL;
    }

    public abstract ConsumerCallbackResult printGenericRecord(GenericRecord var1);
}

