/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;

public class EventInfoDtailPrinter
extends DtailPrinter {
    private static final SimpleDateFormat EVENT_TS_FORMAT = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss");

    public EventInfoDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out) {
        super(client, conf, out);
    }

    private static String versionedSchemaId(VersionedSchema v) {
        return null == v ? "null" : v.getId().toString();
    }

    @Override
    public ConsumerCallbackResult printEvent(DbusEventInternalReadable e, DbusEventDecoder eventDecoder) {
        DbusEventAvroDecoder avroDecoder = (DbusEventAvroDecoder)eventDecoder;
        byte[] payloadSchemaDigest = e.schemaId();
        DbusEventPart metadataPart = e.getPayloadMetadataPart();
        String s = String.format("format=%s opcode=%s partition=%d scn=%d ts=%d (%s.%d) srcid=%d extRepl=%s schema=%s payload_schema_digest=%s metadata_schema=%s metadata_schema_digest=%s", e.getClass().getSimpleName(), e.getOpcode(), e.getPartitionId(), e.sequence(), e.timestampInNanos(), EVENT_TS_FORMAT.format(new Date(e.timestampInNanos() / 1000000L)), e.timestampInNanos() % 1000000000L, e.getSourceId(), e.isExtReplicatedEvent(), EventInfoDtailPrinter.versionedSchemaId(eventDecoder.getPayloadSchema((DbusEvent)e)), null != payloadSchemaDigest ? Hex.encodeHexString((byte[])payloadSchemaDigest) : "null", null != metadataPart ? EventInfoDtailPrinter.versionedSchemaId(avroDecoder.getMetadataSchema((DbusEvent)e)) : "null", null != metadataPart ? Hex.encodeHexString((byte[])metadataPart.getSchemaDigest()) : "null");
        try {
            this._out.write(s.getBytes("UTF-8"));
            this._out.write(10);
        }
        catch (UnsupportedEncodingException e1) {
            return ConsumerCallbackResult.ERROR;
        }
        catch (IOException e1) {
            return ConsumerCallbackResult.ERROR;
        }
        return ConsumerCallbackResult.SUCCESS;
    }

    static {
        EVENT_TS_FORMAT.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
    }
}

