/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Formatter;
import org.apache.log4j.Logger;

public abstract class DtailPrinter
extends AbstractDatabusCombinedConsumer {
    public static final Logger LOG = Logger.getLogger(DtailPrinter.class);
    public static final String GLOBAL_STATS_FORMAT = "\n======== DTAILed STATISTICS =========\nelapsed, ms    : %d\nevents         : %d\nevents/sec     : %6.2f\nwindows        : %d\nwindows/sec    : %6.2f\npayload, total : %d\npayload, MB/s  : %6.2f\navg payload,B  : %d\nbytes, total   : %d\nbytes, MB/s    : %6.2f\navg lag, ms    : %6.2f\n\n";
    protected final DatabusHttpClientImpl _client;
    protected final StaticConfig _conf;
    protected final OutputStream _out;
    protected boolean _done = false;
    protected long _eventsNum = 0L;
    protected long _winNum = 0L;
    protected long _startTs = 0L;
    protected long _endTs = 0L;
    protected long _payloadBytes = 0L;
    protected long _eventBytes = 0L;
    protected long _eventLagNs = 0L;

    public DtailPrinter(DatabusHttpClientImpl client, StaticConfig conf, OutputStream out) {
        this._client = client;
        this._conf = conf;
        this._out = out;
    }

    public abstract ConsumerCallbackResult printEvent(DbusEventInternalReadable var1, DbusEventDecoder var2);

    protected ConsumerCallbackResult processEvent(DbusEventInternalReadable e, DbusEventDecoder eventDecoder) {
        if (this._done) {
            return ConsumerCallbackResult.SUCCESS;
        }
        ConsumerCallbackResult result = this.printEvent(e, eventDecoder);
        if (ConsumerCallbackResult.isSuccess((ConsumerCallbackResult)result)) {
            long elapsed;
            this._endTs = System.currentTimeMillis();
            ++this._eventsNum;
            this._eventBytes += (long)e.size();
            this._payloadBytes += (long)e.payloadLength();
            long lag = this._endTs * 1000000L - e.timestampInNanos();
            this._eventLagNs += lag;
            if (this._eventsNum >= this._conf.getMaxEventsNum()) {
                this._done = true;
                LOG.info((Object)("event limit reached:" + this._eventsNum));
            }
            if ((elapsed = this._endTs - this._startTs) > this._conf.getMaxDurationMs()) {
                this._done = true;
                LOG.info((Object)("time limit reached; elapsed, ms:" + elapsed));
            }
            if (this._done) {
                LOG.info((Object)"Dtail shutting down ...");
                this._client.shutdownAsynchronously();
            }
        }
        return result;
    }

    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        if (!(e instanceof DbusEventInternalReadable)) {
            throw new ClassCastException("DbusEvent not readable");
        }
        DbusEventInternalReadable er = (DbusEventInternalReadable)e;
        return this.processEvent(er, eventDecoder);
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        if (!(e instanceof DbusEventInternalReadable)) {
            throw new ClassCastException("DbusEvent not readable");
        }
        DbusEventInternalReadable er = (DbusEventInternalReadable)e;
        return this.processEvent(er, eventDecoder);
    }

    public ConsumerCallbackResult onStartConsumption() {
        this.startConsumption();
        return super.onStartConsumption();
    }

    public ConsumerCallbackResult onStartBootstrap() {
        this.startConsumption();
        return super.onStartBootstrap();
    }

    protected void startConsumption() {
        if (0L >= this._startTs) {
            this._endTs = this._startTs = System.currentTimeMillis();
            LOG.info((Object)("start timestamp:" + this._startTs));
        }
    }

    public ConsumerCallbackResult onStopConsumption() {
        if (this._conf.isPrintStats()) {
            this.printStats();
        }
        return super.onStopConsumption();
    }

    public void printStats() {
        if (0L == this._winNum) {
            this._winNum = 1L;
        }
        long elapsedMs = this._endTs - this._startTs;
        Formatter fmt = new Formatter();
        fmt.format(GLOBAL_STATS_FORMAT, elapsedMs, this._eventsNum, 1000.0 * (double)this._eventsNum / (double)elapsedMs, this._winNum, 1000.0 * (double)this._winNum / (double)elapsedMs, this._payloadBytes, 1000.0 * (double)this._payloadBytes / (double)elapsedMs, this._payloadBytes / this._eventsNum, this._eventBytes, 1000.0 * (double)this._eventBytes / (double)elapsedMs, 1.0 * (double)this._eventLagNs / (double)(1000000L * this._eventsNum));
        fmt.flush();
        fmt.close();
        String statsStr = fmt.toString();
        try {
            this._out.write(statsStr.getBytes(Charset.defaultCharset()));
            this._out.flush();
        }
        catch (IOException e) {
            LOG.error((Object)"unable to write stats", (Throwable)e);
        }
    }

    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        ++this._winNum;
        return super.onStartDataEventSequence(startScn);
    }

    public static class StaticConfigBuilder
    extends StaticConfigBuilderBase
    implements ConfigBuilder<StaticConfig> {
        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this.getPrintPrintVerbosity(), this.getMaxEventsNum(), this.getMaxDurationMs(), this.isPrintStats());
        }
    }

    protected static class StaticConfigBuilderBase {
        private long _maxEventsNum = Long.MAX_VALUE;
        private PrintVerbosity _printPrintVerbosity = PrintVerbosity.EVENT;
        private long _maxDurationMs = Long.MAX_VALUE;
        private boolean _printStats = false;

        protected StaticConfigBuilderBase() {
        }

        public long getMaxEventsNum() {
            return this._maxEventsNum;
        }

        public void setMaxEventsNum(long maxEventsNum) {
            this._maxEventsNum = maxEventsNum;
        }

        public PrintVerbosity getPrintPrintVerbosity() {
            return this._printPrintVerbosity;
        }

        public void setPrintPrintVerbosity(PrintVerbosity printPrintVerbosity) {
            this._printPrintVerbosity = printPrintVerbosity;
        }

        public long getMaxDurationMs() {
            return this._maxDurationMs;
        }

        public void setMaxDurationMs(long maxDurationMs) {
            this._maxDurationMs = maxDurationMs;
        }

        public boolean isPrintStats() {
            return this._printStats;
        }

        public void setPrintStats(boolean printStats) {
            this._printStats = printStats;
        }
    }

    public static class StaticConfig {
        private final long _maxEventsNum;
        private final PrintVerbosity _printPrintVerbosity;
        private final long _maxDurationMs;
        private final boolean _printStats;

        public StaticConfig(PrintVerbosity printPrintVerbosity, long maxEventsNum, long maxDurationMs, boolean printStats) {
            this._maxEventsNum = maxEventsNum;
            this._printPrintVerbosity = printPrintVerbosity;
            this._maxDurationMs = maxDurationMs;
            this._printStats = printStats;
        }

        public long getMaxEventsNum() {
            return this._maxEventsNum;
        }

        public PrintVerbosity getPrintPrintVerbosity() {
            return this._printPrintVerbosity;
        }

        public long getMaxDurationMs() {
            return this._maxDurationMs;
        }

        public boolean isPrintStats() {
            return this._printStats;
        }
    }

    public static enum MetadataOutput {
        NONE,
        ONLY,
        INCLUDE;

    }

    public static enum PrintVerbosity {
        EVENT,
        SOURCE,
        WINDOW,
        LIFECYCLE;

    }
}

