/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.DatabusBootstrapConsumer;
import com.linkedin.databus.client.pub.DatabusClientException;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusStreamConsumer;
import com.linkedin.databus.core.BaseCli;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import com.linkedin.databus2.tools.dtail.AvroBinaryDtailPrinter;
import com.linkedin.databus2.tools.dtail.AvroJsonDtailPrinter;
import com.linkedin.databus2.tools.dtail.DtailCliBase;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import com.linkedin.databus2.tools.dtail.EventInfoDtailPrinter;
import com.linkedin.databus2.tools.dtail.JsonDtailPrinter;
import com.linkedin.databus2.tools.dtail.NoopDtailPrinter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;

public class Dtail {
    public static final Logger LOG = Logger.getLogger(Dtail.class);
    private final Cli _cli;
    private final DatabusHttpClientImpl _client;
    DatabusCombinedConsumer _consumer = null;

    public Dtail(Cli cli) throws IOException, DatabusException, DatabusClientException, InstantiationException, IllegalAccessException {
        this._cli = cli;
        Properties props = this._cli.getConfigProps();
        DatabusHttpClientImpl.Config configBuilder = DatabusHttpClientImpl.createConfigBuilder((String)"dtail.", (Properties)props);
        String relaysOverride = this._cli.getRelaysOverride();
        configBuilder.getRuntime().setRelaysList(relaysOverride);
        String bstserverOverrides = this._cli.getBstserversOverride();
        configBuilder.getRuntime().getBootstrap().setServicesList(bstserverOverrides);
        if (null == this._cli.getCheckpointDirName()) {
            configBuilder.getCheckpointPersistence().setType(DatabusHttpClientImpl.CheckpointPersistenceStaticConfig.ProviderType.NONE.toString());
        } else {
            configBuilder.getCheckpointPersistence().setType(DatabusHttpClientImpl.CheckpointPersistenceStaticConfig.ProviderType.FILE_SYSTEM.toString());
            configBuilder.getCheckpointPersistence().getFileSystem().setRootDirectory(this._cli.getCheckpointDirName());
        }
        if (cli.isBootstrapEnabled()) {
            configBuilder.getRuntime().getBootstrap().setEnabled(true);
        }
        Checkpoint ckpt = new Checkpoint();
        if (-1000L == cli.getSinceScn()) {
            ckpt.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
            ckpt.setWindowScn(Long.valueOf(0L));
            ckpt.setFlexible();
        } else {
            if (-2000L == cli.getSinceScn()) {
                throw new DatabusException("EOB checkpoint not supported by dtail yet");
            }
            ckpt.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
            ckpt.setWindowScn(Long.valueOf(cli.getSinceScn()));
            ckpt.setWindowOffset(-1L);
        }
        this._client = new DatabusHttpClientImpl(configBuilder);
        if (null != this._client.getCheckpointPersistenceProvider()) {
            this._client.getCheckpointPersistenceProvider().storeCheckpoint(Arrays.asList(cli.getSources()), ckpt);
        }
        DtailPrinter.StaticConfigBuilder consConfBuilder = new DtailPrinter.StaticConfigBuilder();
        consConfBuilder.setPrintPrintVerbosity(cli.getPrintVerbosity());
        consConfBuilder.setMaxEventsNum(cli.getMaxEventNum());
        consConfBuilder.setMaxDurationMs(cli.getDurationMs());
        consConfBuilder.setPrintStats(cli.isShowStats());
        if (null != cli.getConsumerClass()) {
            this._consumer = (DatabusCombinedConsumer)cli.getConsumerClass().newInstance();
        } else {
            switch (cli.getOutputFormat()) {
                case JSON: {
                    this._consumer = new JsonDtailPrinter(this._client, consConfBuilder.build(), cli.getOut());
                    break;
                }
                case AVRO_JSON: {
                    this._consumer = new AvroJsonDtailPrinter(this._client, consConfBuilder.build(), cli.getOut());
                    break;
                }
                case AVRO_BIN: {
                    this._consumer = new AvroBinaryDtailPrinter(this._client, consConfBuilder.build(), cli.getOut());
                    break;
                }
                case NOOP: {
                    this._consumer = new NoopDtailPrinter(this._client, consConfBuilder.build(), cli.getOut());
                    break;
                }
                case EVENT_INFO: {
                    this._consumer = new EventInfoDtailPrinter(this._client, consConfBuilder.build(), cli.getOut());
                    break;
                }
                default: {
                    throw new InvalidConfigException("unsupported output format: " + (Object)((Object)cli.getOutputFormat()));
                }
            }
        }
        DbusKeyCompositeFilterConfig filterConfig = null;
        if (this._cli.getModPartBase() > 0L) {
            DbusKeyCompositeFilterConfig.Config builder = new DbusKeyCompositeFilterConfig.Config();
            for (String src : cli.getSources()) {
                builder.getFilter(src).setType(KeyFilterConfigHolder.PartitionType.MOD.toString());
                builder.getFilter(src).getMod().setNumBuckets(cli.getModPartBase());
                builder.getFilter(src).getMod().setBuckets(cli.getModPartIds());
            }
            filterConfig = new DbusKeyCompositeFilterConfig(builder.build());
        }
        this._client.registerDatabusStreamListener((DatabusStreamConsumer)this._consumer, filterConfig, cli.getSources());
        this._client.registerDatabusBootstrapListener((DatabusBootstrapConsumer)this._consumer, filterConfig, cli.getSources());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
    }

    public void start() {
        this._client.start();
        this._client.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        Cli cli = new Cli();
        if (!cli.processCommandLineArgs(args)) {
            System.exit(1);
        }
        Dtail dtail = new Dtail(cli);
        dtail.start();
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            LOG.info((Object)"Shutdown hook started");
            if (Dtail.this._cli.isShowStats() && null != Dtail.this._consumer && Dtail.this._consumer instanceof DtailPrinter) {
                LOG.info((Object)"Generating stats");
                ((DtailPrinter)Dtail.this._consumer).printStats();
            }
            LOG.info((Object)"Shutdown hook finished");
        }
    }

    static class Cli
    extends DtailCliBase {
        public static final String BOOTSTRAP_OPT_NAME = "with-bootstrap";
        public static final char BOOTSTRAP_OPT_CHAR = 'b';
        public static final String BOOTSTRAP_SERVERS_OPT_NAME = "bstservers";
        public static final String CONFIG_ROOT_OPT_NAME = "config_root";
        public static final String FABRIC_OPT_NAME = "fabric";
        public static final char FABRIC_OPT_CHAR = 'f';
        public static final String MOD_PARTITION_OPT_NAME = "mod_part";
        public static final String RELAYS_OPT_NAME = "relays";
        public static final char RELAYS_OPT_CHAR = 'R';
        public static final String SOURCES_OPT_NAME = "sources";
        public static final char SOURCES_OPT_CHAR = 's';
        public static final String CONSUMER_CLASS_NAME = "consumer";
        protected String _sourcesString;
        protected String[] _sources;
        protected String _relaysOverride;
        protected String _bstserversOverride;
        protected File _configRoot = new File(".");
        protected long _modPartBase = -1L;
        protected String _modPartIds;
        protected boolean _bootstrapEnabled = false;
        protected Class<?> _consumerClass;

        public Cli() {
            super(Cli.constructCliHelp(), Logger.getLogger(Dtail.class));
        }

        private static BaseCli.CliHelp constructCliHelp() {
            return new BaseCli.CliHelpBuilder().className(Dtail.class).startHeader().addSection("Description").addLine("A command-line tool to consume and inspect events from Databus for Oracle").addSection("Options").finish().startFooter().addSection("Examples").addLine("* Print all recent events for source com.linkedin.events.example.Person from the relay relay.host:12345").addLine().addLine("bin/dtail -s com.linkedin.events.example.Person -R relay.host:12345").addLine().addLine("* Print 100 events for sources com.linkedin.events.example.Person and com.linkedin.events.example.Company from the relay relay.host.com:12345 since scn 987654321").addLine().addLine("bin/dtail -s com.linkedin.events.example.Person,com.linkedin.events.example.Company -R relay.host.com:12345 --scn 987654321 -n 100").addLine().addLine("* Bootstrap from SCN 0 for source com.linkedin.events.example.Person using relay relay.host:12345 and bootstrap server  bootsrap.host:11111 using checkpoint directory my_ckpt/ and print out  JSON format suitable for JSON deserialization").addLine().addLine("bin/dtail -s com.linkedin.events.example.Person --scn 0 --relays relay.host:12345 -b --bstservers bootsrap.host:11111  --resume my_ckpt/ -F AVRO_JSON").addLine().addLine("* Consume events for 5 minutes for source com.linkedin.events.example.Person from the relay relay.host.com:12345 since scn 987654321 and print out eventmetadata rather than the payload").addLine().addLine("bin/dtail -s com.linkedin.events.example.Person,com.linkedin.events.example.Company -R relay.host.com:12345 --scn 987654321 -u 5min -F EVENT_INFO").addLine().finish().build();
        }

        @Override
        protected void constructCommandLineOptions() {
            super.constructCommandLineOptions();
            OptionBuilder.withLongOpt((String)SOURCES_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)SOURCES_OPT_NAME);
            OptionBuilder.withDescription((String)"comma-separated list of sources:");
            Option sourcesOption = OptionBuilder.create((char)'s');
            OptionBuilder.withLongOpt((String)CONFIG_ROOT_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"config_rootdir");
            OptionBuilder.withDescription((String)"directory with all config files; default: .");
            Option configRootOption = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)RELAYS_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"relay_list");
            OptionBuilder.withDescription((String)"semicolon-separated list of server:port");
            Option relaysOption = OptionBuilder.create((char)'R');
            OptionBuilder.withLongOpt((String)MOD_PARTITION_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"div:[id1,id2,...]");
            OptionBuilder.withDescription((String)"returns only events for which hash(key) mod div in {id1, ...}");
            Option modPartOption = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)BOOTSTRAP_OPT_NAME);
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withArgName((String)"[true|false]");
            OptionBuilder.withDescription((String)"enable/disable bootstrap; Default: disabled");
            Option bootstrapOption = OptionBuilder.create((char)'b');
            OptionBuilder.withLongOpt((String)BOOTSTRAP_SERVERS_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"bootstrap_server_list");
            OptionBuilder.withDescription((String)"semicolon-separated list of server:port");
            Option bstserversOption = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)CONSUMER_CLASS_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"callback_class");
            OptionBuilder.withDescription((String)"a name of a class that implements the DatabusCombinedConsumer interface and a default constructor. Add your jars to thelib/ directory.");
            Option consumerClassOption = OptionBuilder.create();
            this._cliOptions.addOption(configRootOption);
            this._cliOptions.addOption(sourcesOption);
            this._cliOptions.addOption(relaysOption);
            this._cliOptions.addOption(modPartOption);
            this._cliOptions.addOption(bootstrapOption);
            this._cliOptions.addOption(bstserversOption);
            this._cliOptions.addOption(consumerClassOption);
        }

        private boolean processSources() {
            if (!this._cmd.hasOption('s')) {
                this.printError("sources list expected", true);
                return false;
            }
            this._sourcesString = this._cmd.getOptionValue('s');
            LOG.debug((Object)("sources from cmd=" + this._sourcesString));
            this._sources = this._sourcesString.split(",");
            return true;
        }

        private boolean processConfigRoot() {
            if (this._cmd.hasOption(CONFIG_ROOT_OPT_NAME)) {
                String configRootName = this._cmd.getOptionValue(CONFIG_ROOT_OPT_NAME);
                File f = new File(configRootName);
                if (!f.exists()) {
                    this.printError("config directory " + configRootName + " does not exist", false);
                    return false;
                }
                if (!f.isDirectory()) {
                    this.printError("config directory " + configRootName + " is not a directory", false);
                    return false;
                }
                this._configRoot = f;
            }
            LOG.info((Object)("using config root: " + this._configRoot.getAbsolutePath()));
            return true;
        }

        private void processRelaysOverride() {
            if (this._cmd.hasOption('R')) {
                this._relaysOverride = this._cmd.getOptionValue('R');
                if (!this._relaysOverride.endsWith(String.valueOf(';'))) {
                    this._relaysOverride = this._relaysOverride + ';';
                }
                LOG.info((Object)("Using relays override: " + this._relaysOverride));
                this._relaysOverride = this._relaysOverride.replaceAll(String.valueOf(';'), ':' + this._sourcesString + ';');
            }
        }

        private boolean processModPartition() {
            if (this._cmd.hasOption(MOD_PARTITION_OPT_NAME)) {
                String modPartStr = this._cmd.getOptionValue(MOD_PARTITION_OPT_NAME);
                String[] parts = modPartStr.split(":");
                if (parts.length != 2) {
                    this.printError("invalid mod partition specification: " + modPartStr, true);
                    return false;
                }
                this._modPartBase = Long.parseLong(parts[0]);
                if (this._modPartBase <= 0L) {
                    this.printError("invalid  mod partition specification: " + modPartStr, true);
                    return false;
                }
                this._modPartIds = parts[1];
            }
            return true;
        }

        private void processBootstrap() {
            if (this._cmd.hasOption('b')) {
                String bstValue = this._cmd.getOptionValue('b');
                this._bootstrapEnabled = null == bstValue || 0 == bstValue.trim().length() ? true : Boolean.valueOf(bstValue.trim().toLowerCase());
                LOG.info((Object)("with boostrap enabled: " + this._bootstrapEnabled));
            }
        }

        private void processBootstrapServers() {
            if (this._cmd.hasOption(BOOTSTRAP_SERVERS_OPT_NAME)) {
                this._bstserversOverride = this._cmd.getOptionValue(BOOTSTRAP_SERVERS_OPT_NAME);
                if (!this._bstserversOverride.endsWith(String.valueOf(';'))) {
                    this._bstserversOverride = this._bstserversOverride + ';';
                }
                LOG.info((Object)("Using bootstrap servers override: " + this._bstserversOverride));
                this._bstserversOverride = this._bstserversOverride.replaceAll(String.valueOf(';'), ':' + this._sourcesString + ';');
            }
        }

        protected boolean processConsumerClass() {
            if (this._cmd.hasOption(CONSUMER_CLASS_NAME)) {
                String className = this._cmd.getOptionValue(CONSUMER_CLASS_NAME);
                try {
                    this._consumerClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    this.printError("unable to find consumer callback class " + className, false);
                    return false;
                }
                if (!DatabusCombinedConsumer.class.isAssignableFrom(this._consumerClass)) {
                    this.printError("consumer callback class " + this._consumerClass + " does not implement DatabusCombinedConsumer", false);
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean processCommandLineArgs(String[] cliArgs) {
            super.processCommandLineArgs(cliArgs);
            if (!this.processSources()) {
                return false;
            }
            if (!this.processConfigRoot()) {
                return false;
            }
            this.processRelaysOverride();
            if (!this.processModPartition()) {
                return false;
            }
            this.processBootstrap();
            this.processBootstrapServers();
            return this.processConsumerClass();
        }

        public String[] getSources() {
            return this._sources;
        }

        public File getConfigRoot() {
            return this._configRoot;
        }

        public String getRelaysOverride() {
            return this._relaysOverride;
        }

        public long getModPartBase() {
            return this._modPartBase;
        }

        public String getModPartIds() {
            return this._modPartIds;
        }

        public boolean isBootstrapEnabled() {
            return this._bootstrapEnabled;
        }

        public String getBstserversOverride() {
            return this._bstserversOverride;
        }

        public Class<?> getConsumerClass() {
            return this._consumerClass;
        }
    }
}

