/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import com.linkedin.databus2.tools.dtail.GenericRecordDtailPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.log4j.Logger;

public class AvroJsonDtailPrinter
extends GenericRecordDtailPrinter {
    public static final Logger LOG = Logger.getLogger(AvroJsonDtailPrinter.class);
    private final HashMap<Schema, GenericDatumWriter<GenericRecord>> _jsonWriters = new HashMap(5);
    private final HashMap<Schema, JsonEncoder> _jsonEncoders = new HashMap(5);

    public AvroJsonDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out) {
        this(client, conf, out, DtailPrinter.MetadataOutput.NONE);
    }

    public AvroJsonDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out, DtailPrinter.MetadataOutput metadata) {
        super(client, conf, out, metadata);
    }

    @Override
    public ConsumerCallbackResult printGenericRecord(GenericRecord r) {
        ConsumerCallbackResult result = ConsumerCallbackResult.SUCCESS;
        try {
            GenericDatumWriter datumWriter;
            JsonEncoder jsonEnc = this._jsonEncoders.get(r.getSchema());
            if (null == jsonEnc) {
                jsonEnc = new JsonEncoder(r.getSchema(), this._out);
                this._jsonEncoders.put(r.getSchema(), jsonEnc);
            }
            if (null == (datumWriter = this._jsonWriters.get(r.getSchema()))) {
                datumWriter = new GenericDatumWriter(r.getSchema());
                this._jsonWriters.put(r.getSchema(), (GenericDatumWriter<GenericRecord>)datumWriter);
            }
            datumWriter.write((Object)r, (Encoder)jsonEnc);
            jsonEnc.flush();
            this._out.write(10);
        }
        catch (RuntimeException re) {
            LOG.error((Object)("event dump error: " + re.getMessage()), (Throwable)re);
            result = ConsumerCallbackResult.ERROR;
        }
        catch (IOException ioe) {
            LOG.error((Object)("event dump error: " + ioe.getMessage()), (Throwable)ioe);
            result = ConsumerCallbackResult.ERROR;
        }
        return result;
    }
}

